/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitBodyRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;

public abstract class OAbstractPageWALRecord
extends OOperationUnitBodyRecord {
    private long pageIndex;
    private long fileId;

    protected OAbstractPageWALRecord() {
    }

    protected OAbstractPageWALRecord(long pageIndex, long fileId, OOperationUnitId operationUnitId) {
        super(operationUnitId);
        this.pageIndex = pageIndex;
        this.fileId = fileId;
    }

    @Override
    public int toStream(byte[] content, int offset) {
        offset = super.toStream(content, offset);
        OLongSerializer.INSTANCE.serializeNative(this.pageIndex, content, offset, new Object[0]);
        OLongSerializer.INSTANCE.serializeNative(this.fileId, content, offset += 8, new Object[0]);
        return offset += 8;
    }

    @Override
    public int fromStream(byte[] content, int offset) {
        offset = super.fromStream(content, offset);
        this.pageIndex = OLongSerializer.INSTANCE.deserializeNative(content, offset);
        this.fileId = OLongSerializer.INSTANCE.deserializeNative(content, offset += 8);
        return offset += 8;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public long getFileId() {
        return this.fileId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAbstractPageWALRecord that = (OAbstractPageWALRecord)o;
        if (this.fileId != that.fileId) {
            return false;
        }
        if (this.pageIndex != that.pageIndex) {
            return false;
        }
        return !(this.lsn != null ? !this.lsn.equals(that.lsn) : that.lsn != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.lsn != null ? this.lsn.hashCode() : 0);
        result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
        result = 31 * result + (int)(this.fileId ^ this.fileId >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return this.toString("pageIndex=" + this.pageIndex + ", fileId=" + this.fileId);
    }
}

