/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local.twoq;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.local.twoq.LRUList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentLRUList
implements LRUList {
    private static boolean assertionsEnabled;
    private final ConcurrentHashMap<CacheKey, LRUEntry> cache = new ConcurrentHashMap();
    private final ListNode headReference = new ListNode(null, true);
    private final AtomicReference<ListNode> tailReference = new AtomicReference<ListNode>(this.headReference);
    private final ConcurrentLinkedQueue<ListNode> trash = new ConcurrentLinkedQueue();
    private final int minTrashSize = Runtime.getRuntime().availableProcessors() * 4;
    private final AtomicBoolean purgeInProgress = new AtomicBoolean();
    private final AtomicInteger trashSize = new AtomicInteger();
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public OCacheEntry get(long fileId, long pageIndex) {
        LRUEntry lruEntry = this.cache.get(new CacheKey(fileId, pageIndex));
        this.purge();
        if (lruEntry == null) {
            return null;
        }
        return lruEntry.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry remove(long fileId, long pageIndex) {
        CacheKey key = new CacheKey(fileId, pageIndex);
        LRUEntry valueToRemove = this.cache.remove(key);
        if (valueToRemove == null) {
            return null;
        }
        valueToRemove.removeLock.writeLock().lock();
        try {
            valueToRemove.removed = true;
            ListNode node = (ListNode)valueToRemove.listNode.get();
            valueToRemove.listNode.lazySet(null);
            if (node != null) {
                this.addToTrash(node);
            }
        }
        finally {
            valueToRemove.removeLock.writeLock().unlock();
        }
        this.purge();
        return valueToRemove.entry;
    }

    @Override
    public void putToMRU(OCacheEntry cacheEntry) {
        LRUEntry value;
        CacheKey key = new CacheKey(cacheEntry.getFileId(), cacheEntry.getPageIndex());
        LRUEntry existingValue = this.cache.putIfAbsent(key, value = new LRUEntry(key, cacheEntry));
        if (existingValue != null) {
            existingValue.entry = cacheEntry;
            this.offer(existingValue);
        } else {
            this.offer(value);
        }
        this.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offer(LRUEntry lruEntry) {
        lruEntry.removeLock.readLock().lock();
        try {
            if (lruEntry.removed) {
                return;
            }
            ListNode tail = this.tailReference.get();
            if (!lruEntry.equals(tail.entry)) {
                ListNode oldNode = (ListNode)lruEntry.listNode.get();
                ListNode newNode = new ListNode(lruEntry, false);
                if (lruEntry.listNode.compareAndSet(oldNode, newNode)) {
                    while (true) {
                        newNode.previous.set(tail);
                        if (tail.next.compareAndSet(null, newNode)) break;
                        tail = this.tailReference.get();
                    }
                    this.tailReference.compareAndSet(tail, newNode);
                    if (oldNode != null) {
                        this.addToTrash(oldNode);
                    }
                }
            }
        }
        finally {
            lruEntry.removeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCacheEntry removeLRU() {
        ListNode current = this.headReference;
        boolean removed = false;
        LRUEntry currentEntry = null;
        int inUseCounter = 0;
        while (true) {
            if (current.isDummy || (currentEntry = current.entry) == null || this.isInUse(currentEntry.entry)) {
                ListNode next;
                if (currentEntry != null && this.isInUse(currentEntry.entry)) {
                    ++inUseCounter;
                }
                if ((next = (ListNode)current.next.get()) == null) {
                    if (this.cache.size() == inUseCounter) {
                        return null;
                    }
                    current = this.headReference;
                    inUseCounter = 0;
                    continue;
                }
                current = next;
                continue;
            }
            if (this.cache.remove(currentEntry.key, currentEntry)) {
                currentEntry.removeLock.writeLock().lock();
                try {
                    currentEntry.removed = true;
                    ListNode node = (ListNode)currentEntry.listNode.get();
                    currentEntry.listNode.lazySet(null);
                    this.addToTrash(node);
                    removed = true;
                }
                finally {
                    currentEntry.removeLock.writeLock().unlock();
                }
            } else {
                current = this.headReference;
                inUseCounter = 0;
            }
            if (removed) break;
        }
        this.purge();
        return currentEntry.entry;
    }

    @Override
    public OCacheEntry getLRU() {
        ListNode current = this.headReference;
        LRUEntry currentEntry = null;
        int inUseCounter = 0;
        while (current.isDummy || (currentEntry = current.entry) == null || this.isInUse(currentEntry.entry)) {
            ListNode next;
            if (currentEntry != null && this.isInUse(currentEntry.entry)) {
                ++inUseCounter;
            }
            if ((next = (ListNode)current.next.get()) == null) {
                if (this.cache.size() == inUseCounter) {
                    return null;
                }
                current = this.headReference;
                inUseCounter = 0;
                continue;
            }
            current = next;
        }
        this.purge();
        return currentEntry.entry;
    }

    private void purge() {
        if (this.purgeInProgress.compareAndSet(false, true)) {
            this.purgeSomeFromTrash();
            this.purgeInProgress.set(false);
        }
    }

    private void purgeSomeFromTrash() {
        int additionalSize = 0;
        while (this.trashSize.get() >= this.minTrashSize + additionalSize) {
            ListNode node = this.trash.poll();
            this.trashSize.decrementAndGet();
            if (node == null) {
                return;
            }
            if (node.next.get() == null) {
                this.trash.add(node);
                this.trashSize.incrementAndGet();
                ++additionalSize;
                continue;
            }
            ListNode previous = (ListNode)node.previous.get();
            ListNode next = (ListNode)node.next.get();
            node.previous.lazySet(null);
            if (!$assertionsDisabled && previous.next.get() != node) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && next != null && next.previous.get() != node) {
                throw new AssertionError();
            }
            if (assertionsEnabled) {
                boolean success = previous.next.compareAndSet(node, next);
                if (!$assertionsDisabled && !success) {
                    throw new AssertionError();
                }
            } else {
                previous.next.set(next);
            }
            if (next == null) continue;
            next.previous.set(previous);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.headReference.next.set(null);
        this.tailReference.set(this.headReference);
        this.trash.clear();
        this.trashSize.set(0);
    }

    @Override
    public boolean contains(long fileId, long filePosition) {
        return this.cache.containsKey(new CacheKey(fileId, filePosition));
    }

    private void addToTrash(ListNode node) {
        node.entry = null;
        this.trash.add(node);
        this.trashSize.incrementAndGet();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    private boolean isInUse(OCacheEntry entry) {
        return entry != null && entry.getUsagesCount() != 0;
    }

    @Override
    public Iterator<OCacheEntry> iterator() {
        return new OCacheEntryIterator(this.tailReference.get());
    }

    @Override
    public Iterator<OCacheEntry> reverseIterator() {
        return new OReverseCacheEntryIterator(this.headReference);
    }

    static {
        boolean bl = $assertionsDisabled = !ConcurrentLRUList.class.desiredAssertionStatus();
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }

    private static class ListNode {
        private volatile LRUEntry entry;
        private final AtomicReference<ListNode> next = new AtomicReference();
        private final AtomicReference<ListNode> previous = new AtomicReference();
        private final boolean isDummy;

        private ListNode(LRUEntry key, boolean isDummy) {
            this.entry = key;
            this.isDummy = isDummy;
        }
    }

    private static class LRUEntry {
        private final AtomicReference<ListNode> listNode = new AtomicReference();
        private final CacheKey key;
        private volatile OCacheEntry entry;
        private boolean removed = false;
        private final ReadWriteLock removeLock = new ReentrantReadWriteLock();

        private LRUEntry(CacheKey key, OCacheEntry entry) {
            this.key = key;
            this.entry = entry;
        }
    }

    private static class CacheKey {
        private final long fileId;
        private final long pageIndex;

        private CacheKey(long fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            return this.pageIndex == that.pageIndex;
        }

        public int hashCode() {
            int result = (int)(this.fileId ^ this.fileId >>> 32);
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }
    }

    private static class OReverseCacheEntryIterator
    implements Iterator<OCacheEntry> {
        private ListNode current;

        public OReverseCacheEntryIterator(ListNode start) {
            this.current = start;
            while (this.current != null && this.current.entry == null) {
                this.current = (ListNode)this.current.next.get();
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.current.entry != null;
        }

        @Override
        public OCacheEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            OCacheEntry entry = this.current.entry.entry;
            do {
                this.current = (ListNode)this.current.next.get();
            } while (this.current != null && this.current.entry == null);
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OCacheEntryIterator
    implements Iterator<OCacheEntry> {
        private ListNode current;

        public OCacheEntryIterator(ListNode start) {
            this.current = start;
            while (this.current != null && this.current.entry == null) {
                this.current = (ListNode)this.current.previous.get();
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.current.entry != null;
        }

        @Override
        public OCacheEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            OCacheEntry entry = this.current.entry.entry;
            do {
                this.current = (ListNode)this.current.previous.get();
            } while (this.current != null && this.current.entry == null);
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

