/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OUpdateIncrementItem;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import com.orientechnologies.orient.core.sql.parser.OUpdatePutItem;
import com.orientechnologies.orient.core.sql.parser.OUpdateRemoveItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OUpdateOperations
extends SimpleNode {
    protected static final int TYPE_SET = 0;
    protected static final int TYPE_PUT = 1;
    protected static final int TYPE_MERGE = 2;
    protected static final int TYPE_CONTENT = 3;
    protected static final int TYPE_INCREMENT = 4;
    protected static final int TYPE_ADD = 5;
    protected static final int TYPE_REMOVE = 6;
    protected int type;
    protected List<OUpdateItem> updateItems = new ArrayList<OUpdateItem>();
    protected List<OUpdatePutItem> updatePutItems = new ArrayList<OUpdatePutItem>();
    protected OJson json;
    protected List<OUpdateIncrementItem> updateIncrementItems = new ArrayList<OUpdateIncrementItem>();
    protected List<OUpdateRemoveItem> updateRemoveItems = new ArrayList<OUpdateRemoveItem>();

    public OUpdateOperations(int id) {
        super(id);
    }

    public OUpdateOperations(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        boolean first = true;
        switch (this.type) {
            case 0: {
                builder.append("SET ");
                for (OUpdateItem item : this.updateItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 1: {
                builder.append("PUT ");
                for (OUpdatePutItem item : this.updatePutItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 2: {
                builder.append("MERGE ");
                this.json.toString(params, builder);
                break;
            }
            case 3: {
                builder.append("CONTENT ");
                this.json.toString(params, builder);
                break;
            }
            case 4: {
                builder.append("INCREMENT ");
                for (OUpdateIncrementItem item : this.updateIncrementItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 5: {
                builder.append("ADD ");
                for (OUpdateIncrementItem item : this.updateIncrementItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
            case 6: {
                builder.append("REMOVE ");
                for (OUpdateRemoveItem item : this.updateRemoveItems) {
                    if (!first) {
                        builder.append(", ");
                    }
                    item.toString(params, builder);
                    first = false;
                }
                break;
            }
        }
    }
}

