/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.exception.OCoreException;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.sql.parser.TokenMgrError;

public class OCommandSQLParsingException
extends OCoreException {
    private Integer line;
    private Integer column;
    private String statement;
    private String text;
    private int position;
    private static final long serialVersionUID = -7430575036316163711L;

    public OCommandSQLParsingException(ParseException e, String statement) {
        super(OCommandSQLParsingException.generateMessage(e, statement, e.currentToken.next.beginLine, e.currentToken.next.endColumn));
        this.statement = statement;
        this.line = e.currentToken.next.beginLine;
        this.column = e.currentToken.next.endColumn;
    }

    public OCommandSQLParsingException(TokenMgrError e, String statement) {
        super("Error parsing query: " + statement);
        this.statement = statement;
        this.line = 0;
        this.column = 0;
    }

    private static String generateMessage(ParseException e, String statement, Integer line, Integer column) {
        StringBuilder result = new StringBuilder();
        result.append("Error parsing query:\n");
        String[] stmLines = statement.split("\n");
        for (int i = 0; i < stmLines.length; ++i) {
            result.append(stmLines[i]);
            result.append("\n");
            if (i != line - 1) continue;
            for (int c = 0; c < column - 1; ++c) {
                result.append(' ');
            }
            result.append("^\n");
        }
        result.append(e.getMessage());
        return result.toString();
    }

    private static String makeMessage(int position, String text, String message) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Error on parsing command");
        buffer.append(": ").append(message);
        if (text != null) {
            buffer.append("\nCommand: ");
            buffer.append(text);
            buffer.append("\n---------");
            for (int i = 0; i < position - 1; ++i) {
                buffer.append("-");
            }
            buffer.append("^");
        }
        return buffer.toString();
    }

    public OCommandSQLParsingException(OCommandSQLParsingException exception) {
        super(exception);
        this.text = exception.text;
        this.position = exception.position;
    }

    public OCommandSQLParsingException(String iMessage) {
        super(iMessage);
    }

    public OCommandSQLParsingException(String iMessage, String iText, int iPosition) {
        super(OCommandSQLParsingException.makeMessage(iPosition, iText, iMessage));
        this.text = iText;
        this.position = iPosition;
    }

    public Integer getLine() {
        return this.line;
    }

    public Integer getColumn() {
        return this.column;
    }

    public String getStatement() {
        return this.statement;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OCommandSQLParsingException)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

