/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;

public class ONetworkThreadLocalSerializer {
    private static volatile ThreadLocal<ORecordSerializer> networkSerializer = new ThreadLocal();

    public static ORecordSerializer getNetworkSerializer() {
        return networkSerializer != null ? networkSerializer.get() : null;
    }

    public static void setNetworkSerializer(ORecordSerializer value) {
        networkSerializer.set(value);
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (networkSerializer == null) {
                    networkSerializer = new ThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                networkSerializer = null;
            }
        });
    }
}

