/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class OJSONWriter {
    private static final String DEF_FORMAT = "rid,type,version,class,attribSameRow,indent:2,dateAsLong";
    private final String format;
    private Writer out;
    private boolean prettyPrint = false;
    private boolean firstAttribute = true;

    public OJSONWriter(Writer out) {
        this(out, DEF_FORMAT);
    }

    public OJSONWriter(Writer out, String iJsonFormat) {
        this.out = out;
        this.format = iJsonFormat;
        if (iJsonFormat.contains("prettyPrint")) {
            this.prettyPrint = true;
        }
    }

    public static String writeValue(Object iValue) throws IOException {
        return OJSONWriter.writeValue(iValue, DEF_FORMAT);
    }

    public static String writeValue(Object iValue, String iFormat) throws IOException {
        return OJSONWriter.writeValue(iValue, iFormat, 0, null);
    }

    public static String writeValue(Object iValue, String iFormat, int iIndentLevel, OType valueType) throws IOException {
        boolean oldAutoConvertSettings;
        if (iValue == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder(64);
        if (iValue instanceof ORecordLazyMultiValue) {
            oldAutoConvertSettings = ((ORecordLazyMultiValue)iValue).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)iValue).setAutoConvertToRecord(false);
        } else {
            oldAutoConvertSettings = false;
        }
        if (iValue instanceof Boolean || iValue instanceof Number) {
            buffer.append(iValue.toString());
        } else if (iValue instanceof OIdentifiable) {
            OIdentifiable linked = (OIdentifiable)iValue;
            if (linked.getIdentity().isValid()) {
                buffer.append('\"');
                linked.getIdentity().toString(buffer);
                buffer.append('\"');
            } else if (iFormat != null && iFormat.contains("shallow")) {
                buffer.append("{}");
            } else {
                Object rec = linked.getRecord();
                if (rec != null) {
                    String embeddedFormat = iFormat != null && iFormat.isEmpty() ? "indent:" + iIndentLevel : iFormat + ",indent:" + iIndentLevel;
                    buffer.append(rec.toJSON(embeddedFormat));
                } else {
                    buffer.append("null");
                }
            }
        } else if (iValue.getClass().isArray()) {
            if (iValue instanceof byte[]) {
                buffer.append('\"');
                byte[] source = (byte[])iValue;
                if (iFormat != null && iFormat.contains("shallow")) {
                    buffer.append(source.length);
                } else {
                    buffer.append(OBase64Utils.encodeBytes(source));
                }
                buffer.append('\"');
            } else {
                buffer.append('[');
                int size = Array.getLength(iValue);
                if (iFormat != null && iFormat.contains("shallow")) {
                    buffer.append(size);
                } else {
                    for (int i = 0; i < size; ++i) {
                        if (i > 0) {
                            buffer.append(",");
                        }
                        buffer.append(OJSONWriter.writeValue(Array.get(iValue, i), iFormat));
                    }
                }
                buffer.append(']');
            }
        } else if (iValue instanceof Iterator) {
            OJSONWriter.iteratorToJSON((Iterator)iValue, iFormat, buffer);
        } else if (iValue instanceof Iterable) {
            OJSONWriter.iteratorToJSON(((Iterable)iValue).iterator(), iFormat, buffer);
        } else if (iValue instanceof Map) {
            OJSONWriter.mapToJSON((Map)iValue, iFormat, buffer);
        } else if (iValue instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)iValue;
            buffer.append('{');
            buffer.append(OJSONWriter.writeValue(entry.getKey(), iFormat));
            buffer.append(":");
            if (iFormat.contains("prettyPrint")) {
                buffer.append(' ');
            }
            buffer.append(OJSONWriter.writeValue(entry.getValue(), iFormat));
            buffer.append('}');
        } else if (iValue instanceof Date) {
            if (iFormat.indexOf("dateAsLong") > -1) {
                buffer.append(((Date)iValue).getTime());
            } else {
                buffer.append('\"');
                buffer.append(ODateHelper.getDateTimeFormatInstance().format(iValue));
                buffer.append('\"');
            }
        } else if (iValue instanceof BigDecimal) {
            buffer.append(((BigDecimal)iValue).toPlainString());
        } else if (iValue instanceof ORecordLazyMultiValue) {
            OJSONWriter.iteratorToJSON(((ORecordLazyMultiValue)iValue).rawIterator(), iFormat, buffer);
        } else if (iValue instanceof Iterable) {
            OJSONWriter.iteratorToJSON(((Iterable)iValue).iterator(), iFormat, buffer);
        } else {
            if (valueType == null) {
                valueType = OType.getTypeByValue(iValue);
            }
            if (valueType == OType.CUSTOM) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream object = new ObjectOutputStream(baos);
                object.writeObject(iValue);
                object.flush();
                buffer.append('\"');
                buffer.append(OBase64Utils.encodeBytes(baos.toByteArray()));
                buffer.append('\"');
            } else {
                String v = iValue.toString();
                buffer.append('\"');
                buffer.append(OJSONWriter.encode(v));
                buffer.append('\"');
            }
        }
        if (iValue instanceof ORecordLazyMultiValue) {
            ((ORecordLazyMultiValue)iValue).setAutoConvertToRecord(oldAutoConvertSettings);
        }
        return buffer.toString();
    }

    protected static void iteratorToJSON(Iterator<?> it, String iFormat, StringBuilder buffer) throws IOException {
        buffer.append('[');
        if (iFormat != null && iFormat.contains("shallow")) {
            if (it instanceof OMultiCollectionIterator) {
                buffer.append(((OMultiCollectionIterator)it).size());
            } else {
                int i = 0;
                while (it.hasNext()) {
                    it.next();
                    ++i;
                }
                buffer.append(i);
            }
        } else {
            int i = 0;
            while (it.hasNext()) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(OJSONWriter.writeValue(it.next(), iFormat));
                ++i;
            }
        }
        buffer.append(']');
    }

    public static Object encode(Object iValue) {
        return OIOUtils.encode(iValue);
    }

    public static String listToJSON(Collection<? extends OIdentifiable> iRecords, String iFormat) {
        try {
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter(buffer);
            json.beginCollection(0, false, null);
            if (iRecords != null) {
                if (iFormat != null && iFormat.contains("shallow")) {
                    buffer.append("" + iRecords.size());
                } else {
                    int counter = 0;
                    for (OIdentifiable oIdentifiable : iRecords) {
                        if (oIdentifiable == null) continue;
                        try {
                            String objectJson;
                            String string = objectJson = iFormat != null ? oIdentifiable.getRecord().toJSON(iFormat) : oIdentifiable.getRecord().toJSON();
                            if (counter++ > 0) {
                                buffer.append(",");
                            }
                            buffer.append(objectJson);
                        }
                        catch (Exception e) {
                            OLogManager.instance().error(json, "Error transforming record " + oIdentifiable.getIdentity() + " to JSON", e, new Object[0]);
                        }
                    }
                }
            }
            json.endCollection(0, false);
            return buffer.toString();
        }
        catch (IOException e) {
            throw OException.wrapException(new OSerializationException("Error on serializing collection"), e);
        }
    }

    public static String mapToJSON(Map<?, ?> iMap) {
        return OJSONWriter.mapToJSON(iMap, null, new StringBuilder(128));
    }

    public static String mapToJSON(Map<?, ?> iMap, String iFormat, StringBuilder buffer) {
        try {
            buffer.append('{');
            if (iMap != null) {
                int i = 0;
                for (Map.Entry<?, ?> entry : iMap.entrySet()) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(OJSONWriter.writeValue(entry.getKey(), iFormat));
                    buffer.append(":");
                    buffer.append(OJSONWriter.writeValue(entry.getValue(), iFormat));
                    ++i;
                }
            }
            buffer.append('}');
            return buffer.toString();
        }
        catch (IOException e) {
            throw OException.wrapException(new OSerializationException("Error on serializing map"), e);
        }
    }

    public OJSONWriter beginObject() throws IOException {
        this.beginObject(0, false, null);
        return this;
    }

    public OJSONWriter beginObject(int iIdentLevel) throws IOException {
        this.beginObject(iIdentLevel, false, null);
        return this;
    }

    public OJSONWriter beginObject(Object iName) throws IOException {
        this.beginObject(-1, false, iName);
        return this;
    }

    public OJSONWriter beginObject(int iIdentLevel, boolean iNewLine, Object iName) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(",");
        }
        this.format(iIdentLevel, iNewLine);
        if (iName != null) {
            this.out.append("\"" + iName.toString() + "\":");
            if (this.prettyPrint) {
                this.out.append(' ');
            }
        }
        this.out.append('{');
        this.firstAttribute = true;
        return this;
    }

    public OJSONWriter writeRecord(int iIdentLevel, boolean iNewLine, Object iName, ORecord iRecord) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(",");
        }
        this.format(iIdentLevel, iNewLine);
        if (iName != null) {
            this.out.append("\"" + iName.toString() + "\":");
            if (this.prettyPrint) {
                this.out.append(' ');
            }
        }
        this.out.append(iRecord.toJSON(this.format));
        this.firstAttribute = false;
        return this;
    }

    public OJSONWriter endObject() throws IOException {
        this.format(-1, true);
        this.out.append('}');
        return this;
    }

    public OJSONWriter endObject(int iIdentLevel) throws IOException {
        return this.endObject(iIdentLevel, true);
    }

    public OJSONWriter endObject(int iIdentLevel, boolean iNewLine) throws IOException {
        this.format(iIdentLevel, iNewLine);
        this.out.append('}');
        this.firstAttribute = false;
        return this;
    }

    public OJSONWriter beginCollection(String iName) throws IOException {
        return this.beginCollection(-1, false, iName);
    }

    public OJSONWriter beginCollection(int iIdentLevel, boolean iNewLine, String iName) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(",");
        }
        this.format(iIdentLevel, iNewLine);
        if (iName != null && !iName.isEmpty()) {
            this.out.append(OJSONWriter.writeValue(iName, this.format));
            this.out.append(":");
            if (this.prettyPrint) {
                this.out.append(' ');
            }
        }
        this.out.append("[");
        this.firstAttribute = true;
        return this;
    }

    public OJSONWriter endCollection() throws IOException {
        return this.endCollection(-1, false);
    }

    public OJSONWriter endCollection(int iIdentLevel, boolean iNewLine) throws IOException {
        this.format(iIdentLevel, iNewLine);
        this.firstAttribute = false;
        this.out.append(']');
        return this;
    }

    public OJSONWriter writeObjects(String iName, Object[] ... iPairs) throws IOException {
        return this.writeObjects(-1, false, iName, iPairs);
    }

    public OJSONWriter writeObjects(int iIdentLevel, boolean iNewLine, String iName, Object[] ... iPairs) throws IOException {
        for (int i = 0; i < iPairs.length; ++i) {
            this.beginObject(iIdentLevel, true, iName);
            int k = 0;
            while (k < iPairs[i].length) {
                this.writeAttribute(iIdentLevel + 1, false, (String)iPairs[i][k++], iPairs[i][k++], this.format);
            }
            this.endObject(iIdentLevel, false);
        }
        return this;
    }

    public OJSONWriter writeAttribute(String iName, Object iValue) throws IOException {
        return this.writeAttribute(-1, false, iName, iValue, this.format);
    }

    public OJSONWriter writeAttribute(int iIdentLevel, boolean iNewLine, String iName, Object iValue) throws IOException {
        return this.writeAttribute(iIdentLevel, iNewLine, iName, iValue, this.format, null);
    }

    public OJSONWriter writeAttribute(int iIdentLevel, boolean iNewLine, String iName, Object iValue, String iFormat) throws IOException {
        return this.writeAttribute(iIdentLevel, iNewLine, iName, iValue, iFormat, null);
    }

    public OJSONWriter writeAttribute(int iIdentLevel, boolean iNewLine, String iName, Object iValue, String iFormat, OType valueType) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(",");
        }
        this.format(iIdentLevel, iNewLine);
        if (iName != null) {
            this.out.append(OJSONWriter.writeValue(iName, iFormat));
            this.out.append(":");
            if (this.prettyPrint) {
                this.out.append(' ');
            }
        }
        if (iFormat != null && iFormat.contains("graph") && iName != null && (iName.startsWith("in_") || iName.startsWith("out_")) && (iValue == null || iValue instanceof OIdentifiable)) {
            this.out.append('[');
            if (iValue instanceof OIdentifiable) {
                boolean shallow;
                boolean bl = shallow = iFormat != null && iFormat.contains("shallow");
                if (shallow) {
                    this.out.append("1");
                } else {
                    this.out.append(OJSONWriter.writeValue(iValue, iFormat));
                }
            }
            this.out.append(']');
        } else {
            this.out.append(OJSONWriter.writeValue(iValue, iFormat, iIdentLevel, valueType));
        }
        this.firstAttribute = false;
        return this;
    }

    public OJSONWriter writeValue(int iIdentLevel, boolean iNewLine, Object iValue) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(",");
        }
        this.format(iIdentLevel, iNewLine);
        this.out.append(OJSONWriter.writeValue(iValue, this.format));
        this.firstAttribute = false;
        return this;
    }

    public OJSONWriter flush() throws IOException {
        this.out.flush();
        return this;
    }

    public OJSONWriter close() throws IOException {
        this.out.close();
        return this;
    }

    public OJSONWriter append(String iText) throws IOException {
        this.out.append(iText);
        return this;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public OJSONWriter setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public void write(String iText) throws IOException {
        this.out.append(iText);
    }

    public void newline() throws IOException {
        if (this.prettyPrint) {
            this.out.append("\r\n");
        }
    }

    public void resetAttributes() {
        this.firstAttribute = true;
    }

    private OJSONWriter format(int iIdentLevel, boolean iNewLine) throws IOException {
        if (iIdentLevel > -1) {
            if (iNewLine) {
                this.newline();
            }
            if (this.prettyPrint) {
                for (int i = 0; i < iIdentLevel; ++i) {
                    this.out.append("  ");
                }
            }
        }
        return this;
    }
}

