/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool.importer;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.importer.OConverterData;
import com.orientechnologies.orient.core.db.tool.importer.OImportConvertersFactory;
import com.orientechnologies.orient.core.db.tool.importer.OValuesConverter;

public abstract class OAbstractCollectionConverter<T>
implements OValuesConverter<T> {
    private final OConverterData converterData;

    protected OAbstractCollectionConverter(OConverterData converterData) {
        this.converterData = converterData;
    }

    protected boolean convertSingleValue(Object item, ResultCallback result, boolean updated) {
        if (item == null) {
            return false;
        }
        if (item instanceof OIdentifiable) {
            OValuesConverter converter = OImportConvertersFactory.INSTANCE.getConverter(item, this.converterData);
            OIdentifiable newValue = converter.convert((OIdentifiable)item);
            if (newValue != OImportConvertersFactory.BROKEN_LINK) {
                result.add(newValue);
            }
            if (!newValue.equals(item)) {
                updated = true;
            }
        } else {
            OValuesConverter valuesConverter = OImportConvertersFactory.INSTANCE.getConverter(item.getClass(), this.converterData);
            if (valuesConverter == null) {
                result.add(item);
            } else {
                Object newValue = valuesConverter.convert(item);
                if (newValue != item) {
                    updated = true;
                }
                result.add(newValue);
            }
        }
        return updated;
    }

    public static interface ResultCallback {
        public void add(Object var1);
    }
}

