/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.compression.impl;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.compression.impl.OZIPCompression;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class OZIPCompressionUtil {
    public static List<String> compressDirectory(String sourceFolderName, ZipOutputStream zos, String[] iSkipFileExtensions, OCommandOutputListener iOutput) throws IOException {
        ArrayList<String> compressedFiles = new ArrayList<String>();
        OZIPCompressionUtil.addFolder(zos, sourceFolderName, sourceFolderName, iSkipFileExtensions, iOutput, compressedFiles);
        return compressedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncompressDirectory(InputStream in, String out, OCommandOutputListener iListener) throws IOException {
        File outdir = new File(out);
        String targetDirPath = outdir.getCanonicalPath() + File.separator;
        ZipInputStream zin = new ZipInputStream(in);
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                File file = new File(outdir, name);
                if (!file.getCanonicalPath().startsWith(targetDirPath)) {
                    throw new IOException("Expanding '" + entry.getName() + "' would create file outside of directory '" + outdir + "'");
                }
                if (entry.isDirectory()) {
                    OZIPCompressionUtil.mkdirs(outdir, name);
                    continue;
                }
                String dir = OZIPCompressionUtil.getDirectoryPart(name);
                if (dir != null) {
                    OZIPCompressionUtil.mkdirs(outdir, dir);
                }
                OZIPCompressionUtil.extractFile(zin, outdir, name, iListener);
            }
        }
        finally {
            zin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractFile(ZipInputStream in, File outdir, String name, OCommandOutputListener iListener) throws IOException {
        if (iListener != null) {
            iListener.onMessage("\n- Uncompressing file " + name + "...");
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        try {
            OIOUtils.copyStream(in, out, -1L);
        }
        finally {
            out.close();
        }
    }

    private static void mkdirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private static String getDirectoryPart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }

    private static void addFolder(ZipOutputStream zos, String path, String baseFolderName, String[] iSkipFileExtensions, OCommandOutputListener iOutput, List<String> iCompressedFiles) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] f2 = f.listFiles();
                for (int i = 0; i < f2.length; ++i) {
                    OZIPCompressionUtil.addFolder(zos, f2[i].getAbsolutePath(), baseFolderName, iSkipFileExtensions, iOutput, iCompressedFiles);
                }
            } else {
                String entryName = path.substring(baseFolderName.length() + 1, path.length());
                if (iSkipFileExtensions != null) {
                    for (String skip : iSkipFileExtensions) {
                        if (!entryName.endsWith(skip)) continue;
                        return;
                    }
                }
                iCompressedFiles.add(path);
                OZIPCompressionUtil.addFile(zos, path, entryName, iOutput);
            }
        } else {
            throw new IllegalArgumentException("Directory " + path + " not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFile(String folderName, String entryName, OutputStream output, OCommandOutputListener iOutput, int compressionLevel) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(output);
        zos.setComment("OrientDB Backup executed on " + new Date());
        try {
            zos.setLevel(compressionLevel);
            OZIPCompressionUtil.addFile(zos, folderName + "/" + entryName, entryName, iOutput);
        }
        finally {
            zos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compressFiles(String folderName, String[] entryNames, OutputStream output, OCommandOutputListener iOutput, int compressionLevel) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(output);
        zos.setComment("OrientDB Backup executed on " + new Date());
        try {
            zos.setLevel(compressionLevel);
            for (String entryName : entryNames) {
                OZIPCompressionUtil.addFile(zos, folderName + "/" + entryName, entryName, iOutput);
            }
        }
        finally {
            zos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFile(ZipOutputStream zos, String folderName, String entryName, OCommandOutputListener iOutput) throws IOException {
        long begin = System.currentTimeMillis();
        if (iOutput != null) {
            iOutput.onMessage("\n- Compressing file " + entryName + "...");
        }
        ZipEntry ze = new ZipEntry(entryName);
        zos.putNextEntry(ze);
        try {
            FileInputStream in = new FileInputStream(folderName);
            try {
                OIOUtils.copyStream(in, zos, -1L);
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            if (iOutput != null) {
                iOutput.onMessage("error: " + e);
            }
            OLogManager.instance().error(OZIPCompression.class, "Cannot compress file: %s", e, folderName);
            throw e;
        }
        finally {
            zos.closeEntry();
        }
        if (iOutput != null) {
            long ratio = ze.getSize() > 0L ? 100L - ze.getCompressedSize() * 100L / ze.getSize() : 0L;
            iOutput.onMessage("ok size=" + OFileUtils.getSizeAsString(ze.getSize()) + " compressedSize=" + ze.getCompressedSize() + " ratio=" + ratio + "%% elapsed=" + OIOUtils.getTimeAsString(System.currentTimeMillis() - begin) + "");
        }
    }
}

