/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.hook.ORecordHookAbstract;
import com.orientechnologies.orient.core.record.ORecord;

public class OCommandCacheHook
extends ORecordHookAbstract
implements ORecordHook.Scoped {
    private static final ORecordHook.SCOPE[] SCOPES = new ORecordHook.SCOPE[]{ORecordHook.SCOPE.CREATE, ORecordHook.SCOPE.UPDATE, ORecordHook.SCOPE.DELETE};
    private final OCommandCache cmdCache;
    private final ODatabaseDocument database;

    public OCommandCacheHook(ODatabaseDocument iDatabase) {
        this.database = iDatabase;
        this.cmdCache = iDatabase.getMetadata().getCommandCache().isEnabled() ? iDatabase.getMetadata().getCommandCache() : null;
    }

    @Override
    public ORecordHook.SCOPE[] getScopes() {
        return SCOPES;
    }

    @Override
    public void onRecordAfterCreate(ORecord iRecord) {
        if (this.cmdCache == null) {
            return;
        }
        this.invalidateCache(iRecord);
    }

    @Override
    public void onRecordAfterUpdate(ORecord iRecord) {
        if (this.cmdCache == null) {
            return;
        }
        this.invalidateCache(iRecord);
    }

    @Override
    public void onRecordAfterDelete(ORecord iRecord) {
        if (this.cmdCache == null) {
            return;
        }
        this.invalidateCache(iRecord);
    }

    protected void invalidateCache(ORecord iRecord) {
        if (this.cmdCache.getEvictStrategy() == OCommandCache.STRATEGY.PER_CLUSTER) {
            this.cmdCache.invalidateResultsOfCluster(this.database.getClusterNameById(iRecord.getIdentity().getClusterId()));
        } else {
            this.cmdCache.invalidateResultsOfCluster(null);
        }
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }
}

