/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.reflection;

import com.orientechnologies.common.log.OLogManager;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class OReflectionHelper {
    private static final String CLASS_EXTENSION = ".class";

    public static List<Class<?>> getClassesFor(Collection<String> classNames, ClassLoader classLoader) throws ClassNotFoundException {
        ArrayList classes = new ArrayList(classNames.size());
        for (String className : classNames) {
            classes.add(Class.forName(className, true, classLoader));
        }
        return classes;
    }

    public static List<Class<?>> getClassesFor(String iPackageName, ClassLoader iClassLoader) throws ClassNotFoundException {
        String className;
        ArrayList<File> directories;
        ArrayList classes;
        block13: {
            classes = new ArrayList();
            directories = new ArrayList<File>();
            try {
                String packageUrl = iPackageName.replace('.', '/');
                Enumeration<URL> resources = iClassLoader.getResources(packageUrl);
                if (!resources.hasMoreElements()) {
                    resources = iClassLoader.getResources(packageUrl + CLASS_EXTENSION);
                    if (resources.hasMoreElements()) {
                        throw new IllegalArgumentException(iPackageName + " does not appear to be a valid package but a class");
                    }
                    break block13;
                }
                while (resources.hasMoreElements()) {
                    URL res = resources.nextElement();
                    if (res.getProtocol().equalsIgnoreCase("jar")) {
                        JarURLConnection conn = (JarURLConnection)res.openConnection();
                        JarFile jar = conn.getJarFile();
                        for (JarEntry e : Collections.list(jar.entries())) {
                            if (!e.getName().startsWith(iPackageName.replace('.', '/')) || !e.getName().endsWith(CLASS_EXTENSION) || e.getName().contains("$")) continue;
                            className = e.getName().replace("/", ".").substring(0, e.getName().length() - 6);
                            classes.add(Class.forName(className, true, iClassLoader));
                        }
                        continue;
                    }
                    directories.add(new File(URLDecoder.decode(res.getPath(), "UTF-8")));
                }
            }
            catch (NullPointerException x) {
                throw new ClassNotFoundException(iPackageName + " does not appear to be a valid package (Null pointer exception)", x);
            }
            catch (UnsupportedEncodingException encex) {
                throw new ClassNotFoundException(iPackageName + " does not appear to be a valid package (Unsupported encoding)", encex);
            }
            catch (IOException ioex) {
                throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + iPackageName, ioex);
            }
        }
        for (File directory : directories) {
            if (directory.exists()) {
                File[] files;
                for (File file : files = directory.listFiles()) {
                    if (file.isDirectory()) {
                        classes.addAll(OReflectionHelper.findClasses(file, iPackageName, iClassLoader));
                        continue;
                    }
                    if (!file.getName().endsWith(CLASS_EXTENSION)) continue;
                    className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length());
                    classes.add(Class.forName(iPackageName + '.' + className, true, iClassLoader));
                }
                continue;
            }
            throw new ClassNotFoundException(iPackageName + " (" + directory.getPath() + ") does not appear to be a valid package");
        }
        return classes;
    }

    private static List<Class<?>> findClasses(File iDirectory, String iPackageName, ClassLoader iClassLoader) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!iDirectory.exists()) {
            return classes;
        }
        iPackageName = iPackageName + "." + iDirectory.getName();
        File[] files = iDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    if (file.getName().contains(".")) continue;
                    classes.addAll(OReflectionHelper.findClasses(file, iPackageName, iClassLoader));
                    continue;
                }
                if (!file.getName().endsWith(CLASS_EXTENSION)) continue;
                String className = file.getName().substring(0, file.getName().length() - CLASS_EXTENSION.length());
                classes.add(Class.forName(iPackageName + '.' + className, true, iClassLoader));
            }
        }
        return classes;
    }

    public static List<Class<?>> getClassessOfInterface(String thePackage, Class<?> theInterface, ClassLoader iClassLoader) {
        ArrayList classList = new ArrayList();
        try {
            for (Class<?> discovered : OReflectionHelper.getClassesFor(thePackage, iClassLoader)) {
                if (!Arrays.asList(discovered.getInterfaces()).contains(theInterface)) continue;
                classList.add(discovered);
            }
        }
        catch (ClassNotFoundException ex) {
            OLogManager.instance().error(null, "Error finding classes", ex, new Object[0]);
        }
        return classList;
    }

    public static Type[] getGenericTypes(Class<?> iClass) {
        ParameterizedType pt;
        Type genericType = iClass.getGenericInterfaces()[0];
        if (genericType != null && genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments() != null && pt.getActualTypeArguments().length > 1) {
            return pt.getActualTypeArguments();
        }
        return null;
    }

    public static Class<?> getGenericMultivalueType(Field p) {
        if (p.getType() instanceof Class) {
            Type genericType = p.getGenericType();
            if (genericType != null && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                if (pt.getActualTypeArguments() != null && pt.getActualTypeArguments().length > 0) {
                    if (((Class)pt.getRawType()).isAssignableFrom(Map.class)) {
                        if (pt.getActualTypeArguments()[1] instanceof Class) {
                            return (Class)pt.getActualTypeArguments()[1];
                        }
                        if (pt.getActualTypeArguments()[1] instanceof ParameterizedType) {
                            return (Class)((ParameterizedType)pt.getActualTypeArguments()[1]).getRawType();
                        }
                    } else {
                        if (pt.getActualTypeArguments()[0] instanceof Class) {
                            return (Class)pt.getActualTypeArguments()[0];
                        }
                        if (pt.getActualTypeArguments()[0] instanceof ParameterizedType) {
                            return (Class)((ParameterizedType)pt.getActualTypeArguments()[0]).getRawType();
                        }
                    }
                }
            } else if (p.getType().isArray()) {
                return p.getType().getComponentType();
            }
        }
        return null;
    }

    public static boolean isJavaType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.getName().startsWith("java.lang")) {
            return true;
        }
        if (clazz.getName().startsWith("java.util")) {
            return true;
        }
        return clazz.isArray();
    }
}

