/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.directmemory.OByteBufferPoolMXBean;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMemory;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.LogManager;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OByteBufferPool
implements OOrientShutdownListener,
OByteBufferPoolMXBean {
    private static final Class<?> cleaner;
    private static final Method clean;
    private static final Class<?> directBuffer;
    private static final Method getCleaner;
    private static final Method attachment;
    public static final String MBEAN_NAME = "com.orientechnologies.common.directmemory:type=OByteBufferPoolMXBean";
    private static final boolean TRACK;
    private final int pageSize;
    private final ConcurrentHashMap<Integer, BufferHolder> preallocatedAreas = new ConcurrentHashMap();
    private final AtomicLong nextAllocationPosition = new AtomicLong();
    private final int maxPagesPerSingleArea;
    private final long preAllocationLimit;
    private final ConcurrentLinkedQueue<ByteBuffer> pool = new ConcurrentLinkedQueue();
    private final AtomicLong overflowBufferCount = new AtomicLong();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();
    private final AtomicInteger poolSize = new AtomicInteger();
    private final AtomicLong allocatedMemory = new AtomicLong();
    private final ReferenceQueue<ByteBuffer> trackedBuffersQueue;
    private final Set<TrackedBufferReference> trackedReferences;
    private final Map<TrackedBufferKey, TrackedBufferReference> trackedBuffers;
    private final Map<TrackedBufferKey, Exception> trackedReleases;

    public static OByteBufferPool instance() {
        return InstanceHolder.INSTANCE;
    }

    public OByteBufferPool(int pageSize) {
        this(pageSize, -1, -1L);
    }

    public OByteBufferPool(int pageSize, int maxChunkSize, long preAllocationLimit) {
        this.pageSize = pageSize;
        this.preAllocationLimit = preAllocationLimit / (long)pageSize * (long)pageSize;
        int pagesPerArea = maxChunkSize / pageSize;
        if (pagesPerArea > 1) {
            pagesPerArea = this.closestPowerOfTwo(pagesPerArea);
            while ((long)pagesPerArea * (long)pageSize >= (long)maxChunkSize) {
                pagesPerArea >>>= 1;
            }
            this.maxPagesPerSingleArea = pagesPerArea;
        } else {
            this.maxPagesPerSingleArea = 1;
        }
        if (TRACK) {
            this.trackedBuffersQueue = new ReferenceQueue();
            this.trackedReferences = new HashSet<TrackedBufferReference>();
            this.trackedBuffers = new HashMap<TrackedBufferKey, TrackedBufferReference>();
            this.trackedReleases = new HashMap<TrackedBufferKey, Exception>();
        } else {
            this.trackedBuffersQueue = null;
            this.trackedReferences = null;
            this.trackedBuffers = null;
            this.trackedReleases = null;
        }
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    public int getSize() {
        return this.pool.size();
    }

    public int getMaxPagesPerChunk() {
        return this.maxPagesPerSingleArea;
    }

    private int closestPowerOfTwo(int value) {
        int n = value - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public ByteBuffer acquireDirect(boolean clear) {
        ByteBuffer buffer = this.pool.poll();
        if (buffer != null) {
            this.poolSize.decrementAndGet();
            if (clear) {
                buffer.position(0);
                buffer.put(new byte[this.pageSize]);
            }
            buffer.position(0);
            return this.trackBuffer(buffer);
        }
        if (this.maxPagesPerSingleArea > 1) {
            long currentAllocationPosition;
            do {
                if ((currentAllocationPosition = this.nextAllocationPosition.get()) < this.preAllocationLimit) continue;
                this.overflowBufferCount.incrementAndGet();
                this.allocatedMemory.getAndAdd(this.pageSize);
                return this.trackBuffer(ByteBuffer.allocateDirect(this.pageSize).order(ByteOrder.nativeOrder()));
            } while (!this.nextAllocationPosition.compareAndSet(currentAllocationPosition, currentAllocationPosition + 1L));
            int position = (int)(currentAllocationPosition & (long)(this.maxPagesPerSingleArea - 1));
            int bufferIndex = (int)(currentAllocationPosition / (long)this.maxPagesPerSingleArea);
            int allocationSize = (int)Math.min((long)(this.maxPagesPerSingleArea * this.pageSize), this.preAllocationLimit - (long)bufferIndex * (long)this.maxPagesPerSingleArea * (long)this.pageSize);
            if (allocationSize <= position * this.pageSize) {
                this.overflowBufferCount.incrementAndGet();
                this.allocatedMemory.getAndAdd(this.pageSize);
                return this.trackBuffer(ByteBuffer.allocateDirect(this.pageSize).order(ByteOrder.nativeOrder()));
            }
            BufferHolder bfh = this.preallocatedAreas.get(bufferIndex);
            if (bfh == null) {
                bfh = new BufferHolder();
                BufferHolder replacedBufferHolder = this.preallocatedAreas.putIfAbsent(bufferIndex, bfh);
                if (replacedBufferHolder == null) {
                    this.allocateBuffer(bfh, allocationSize);
                } else {
                    bfh = replacedBufferHolder;
                }
            }
            if (bfh.buffer == null) {
                try {
                    bfh.latch.await();
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OInterruptedException("Wait of new preallocated memory area was interrupted"), e);
                }
            }
            int rawPosition = position * this.pageSize;
            ByteBuffer db = bfh.buffer.duplicate();
            db.position(rawPosition);
            db.limit(rawPosition + this.pageSize);
            ByteBuffer slice = db.slice();
            slice.order(ByteOrder.nativeOrder());
            if (clear) {
                slice.position(0);
                slice.put(new byte[this.pageSize]);
            }
            slice.position(0);
            return this.trackBuffer(slice);
        }
        this.overflowBufferCount.incrementAndGet();
        this.allocatedMemory.getAndAdd(this.pageSize);
        return this.trackBuffer(ByteBuffer.allocateDirect(this.pageSize).order(ByteOrder.nativeOrder()));
    }

    private void allocateBuffer(BufferHolder bfh, int allocationSize) {
        try {
            bfh.buffer = ByteBuffer.allocateDirect(allocationSize).order(ByteOrder.nativeOrder());
            this.allocatedMemory.getAndAdd(allocationSize);
        }
        finally {
            bfh.latch.countDown();
        }
    }

    public void release(ByteBuffer buffer) {
        this.pool.offer(this.untrackBuffer(buffer));
        this.poolSize.incrementAndGet();
    }

    @Override
    public int getBufferSize() {
        return this.pageSize;
    }

    @Override
    public long getPreAllocatedBufferCount() {
        return this.nextAllocationPosition.get();
    }

    @Override
    public long getOverflowBufferCount() {
        return this.overflowBufferCount.get();
    }

    @Override
    public int getBuffersInThePool() {
        return this.getSize();
    }

    @Override
    public long getAllocatedMemory() {
        return this.allocatedMemory.get();
    }

    @Override
    public long getAllocatedMemoryInMB() {
        return this.getAllocatedMemory() / 0x100000L;
    }

    @Override
    public double getAllocatedMemoryInGB() {
        return Math.ceil((double)(this.getAllocatedMemory() * 100L) / 1.073741824E9) / 100.0;
    }

    @Override
    public long getPreAllocationLimit() {
        return this.preAllocationLimit;
    }

    @Override
    public int getMaxPagesPerSingleArea() {
        return this.maxPagesPerSingleArea;
    }

    @Override
    public int getPoolSize() {
        return this.poolSize.get();
    }

    public void registerMBean() {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                if (!server.isRegistered(mbeanName)) {
                    server.registerMBean(this, mbeanName);
                } else {
                    this.mbeanIsRegistered.set(false);
                    OLogManager.instance().warn((Object)this, "MBean with name %s has already registered. Probably your system was not shutdown correctly or you have several running applications which use OrientDB engine inside", mbeanName.getCanonicalName());
                }
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
            catch (NotCompliantMBeanException e) {
                throw OException.wrapException(new OSystemException("Error during registration of byte buffer pool MBean"), e);
            }
        }
    }

    public void unregisterMBean() {
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(MBEAN_NAME);
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
            catch (InstanceNotFoundException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
            catch (MBeanRegistrationException e) {
                throw OException.wrapException(new OSystemException("Error during unregistration of byte buffer pool MBean"), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyState() {
        if (TRACK) {
            OByteBufferPool oByteBufferPool = this;
            synchronized (oByteBufferPool) {
                boolean logsInAssertions = OByteBufferPool.logInAssertion();
                StringBuilder builder = logsInAssertions ? new StringBuilder() : null;
                for (TrackedBufferReference reference : this.trackedReferences) {
                    OByteBufferPool.log(builder, this, "DIRECT-TRACK: unreleased direct memory buffer `%X` detected.", reference.stackTrace, reference.id);
                }
                this.checkTrackedBuffersLeaks(builder);
                if (logsInAssertions) {
                    if (builder.length() > 0) {
                        throw new AssertionError((Object)builder.toString());
                    }
                } else assert (this.trackedReferences.size() == 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTrackedBufferInfo(String prefix, ByteBuffer buffer) {
        if (TRACK) {
            OByteBufferPool oByteBufferPool = this;
            synchronized (oByteBufferPool) {
                TrackedBufferKey trackedBufferKey = new TrackedBufferKey(buffer);
                TrackedBufferReference reference = this.trackedBuffers.get(trackedBufferKey);
                StringBuilder builder = new StringBuilder();
                builder.append("DIRECT-TRACK: ").append(prefix).append(String.format(" buffer `%X` ", OByteBufferPool.id(buffer)));
                if (reference == null) {
                    builder.append("untracked");
                } else {
                    builder.append("allocated from: ").append('\n').append(OByteBufferPool.getStackTraceAsString(reference.stackTrace)).append('\n');
                }
                Exception release = this.trackedReleases.get(trackedBufferKey);
                if (release != null) {
                    builder.append("released from: ").append('\n').append(OByteBufferPool.getStackTraceAsString(release)).append('\n');
                }
                OLogManager.instance().error(this, builder.toString(), null, new Object[0]);
            }
        }
    }

    @Override
    public void onShutdown() {
        Set<ByteBuffer> cleaned = Collections.newSetFromMap(new IdentityHashMap());
        try {
            for (ByteBuffer byteBuffer : this.pool) {
                this.clean(byteBuffer, cleaned);
            }
        }
        catch (Exception ignore) {
            return;
        }
        if (this.preallocatedAreas != null) {
            for (BufferHolder bufferHolder : this.preallocatedAreas.values()) {
                this.clean(bufferHolder.buffer, cleaned);
            }
            this.preallocatedAreas.clear();
        }
        this.nextAllocationPosition.set(0L);
        this.pool.clear();
        this.overflowBufferCount.set(0L);
        this.poolSize.set(0);
        this.allocatedMemory.set(0L);
        if (TRACK) {
            for (TrackedBufferReference reference : this.trackedReferences) {
                reference.clear();
            }
            this.trackedReferences.clear();
            this.trackedBuffers.clear();
            this.trackedReleases.clear();
            while (this.trackedBuffersQueue.poll() != null) {
            }
        }
    }

    private void clean(ByteBuffer buffer, Set<ByteBuffer> cleaned) {
        if (cleaner == null || directBuffer == null) {
            return;
        }
        ByteBuffer directByteBufferWithCleaner = OByteBufferPool.findDirectByteBufferWithCleaner(buffer, 16);
        if (directByteBufferWithCleaner != null && !cleaned.contains(directByteBufferWithCleaner)) {
            Object cleaner;
            if (getCleaner == null) {
                return;
            }
            try {
                cleaner = getCleaner.invoke((Object)directByteBufferWithCleaner, new Object[0]);
            }
            catch (IllegalAccessException ignore) {
                return;
            }
            catch (InvocationTargetException ignore) {
                return;
            }
            if (clean == null) {
                return;
            }
            try {
                clean.invoke(cleaner, new Object[0]);
            }
            catch (IllegalAccessException ignore) {
                return;
            }
            catch (InvocationTargetException ignore) {
                return;
            }
            cleaned.add(directByteBufferWithCleaner);
            if (TRACK) {
                OLogManager.instance().info((Object)this, "DIRECT-TRACK: cleaned " + directByteBufferWithCleaner, new Object[0]);
            }
        }
    }

    private static ByteBuffer findDirectByteBufferWithCleaner(ByteBuffer buffer, int depthLimit) {
        Object att;
        Object cleaner;
        if (depthLimit == 0) {
            return null;
        }
        if (directBuffer == null || !directBuffer.isAssignableFrom(buffer.getClass())) {
            return null;
        }
        if (getCleaner == null) {
            return null;
        }
        try {
            cleaner = getCleaner.invoke((Object)buffer, new Object[0]);
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (InvocationTargetException ignore) {
            return null;
        }
        if (cleaner != null) {
            return buffer;
        }
        if (attachment == null) {
            return null;
        }
        try {
            att = attachment.invoke((Object)buffer, new Object[0]);
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (InvocationTargetException ignore) {
            return null;
        }
        if (!(att instanceof ByteBuffer)) {
            return null;
        }
        return OByteBufferPool.findDirectByteBufferWithCleaner((ByteBuffer)att, depthLimit - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer trackBuffer(ByteBuffer buffer) {
        if (TRACK) {
            OByteBufferPool oByteBufferPool = this;
            synchronized (oByteBufferPool) {
                boolean logInAssertion = OByteBufferPool.logInAssertion();
                StringBuilder logBuilder = logInAssertion ? new StringBuilder() : null;
                TrackedBufferReference reference = new TrackedBufferReference(buffer, this.trackedBuffersQueue);
                this.trackedReferences.add(reference);
                this.trackedBuffers.put(new TrackedBufferKey(buffer), reference);
                this.checkTrackedBuffersLeaks(logBuilder);
                if (logInAssertion && logBuilder.length() > 0) {
                    throw new AssertionError((Object)logBuilder.toString());
                }
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer untrackBuffer(ByteBuffer buffer) {
        if (TRACK) {
            OByteBufferPool oByteBufferPool = this;
            synchronized (oByteBufferPool) {
                boolean logInAssertion = OByteBufferPool.logInAssertion();
                StringBuilder logBuilder = logInAssertion ? new StringBuilder() : null;
                TrackedBufferKey trackedBufferKey = new TrackedBufferKey(buffer);
                TrackedBufferReference reference = this.trackedBuffers.remove(trackedBufferKey);
                if (reference == null) {
                    OByteBufferPool.log(logBuilder, this, "DIRECT-TRACK: untracked direct byte buffer `%X` detected.", new Exception(), OByteBufferPool.id(buffer));
                    Exception lastRelease = this.trackedReleases.get(trackedBufferKey);
                    if (lastRelease != null) {
                        OByteBufferPool.log(logBuilder, this, "DIRECT-TRACK: last release.", lastRelease, new Object[0]);
                    }
                    if (logInAssertion) {
                        if (logBuilder.length() > 0) {
                            throw new AssertionError((Object)logBuilder.toString());
                        }
                    } else assert (false);
                } else {
                    this.trackedReferences.remove(reference);
                }
                this.trackedReleases.put(trackedBufferKey, new Exception());
                this.checkTrackedBuffersLeaks(logBuilder);
                if (logInAssertion && logBuilder.length() > 0) {
                    throw new AssertionError((Object)logBuilder.toString());
                }
            }
        }
        return buffer;
    }

    private void checkTrackedBuffersLeaks(StringBuilder logBuilder) {
        TrackedBufferReference reference;
        boolean leaked = false;
        while ((reference = (TrackedBufferReference)this.trackedBuffersQueue.poll()) != null) {
            if (!this.trackedReferences.remove(reference)) continue;
            OByteBufferPool.log(logBuilder, this, "DIRECT-TRACK: unreleased direct byte buffer `%X` detected.", reference.stackTrace, reference.id);
            leaked = true;
        }
        if (logBuilder == null) assert (!leaked);
    }

    private static int id(Object object) {
        return System.identityHashCode(object);
    }

    private static boolean logInAssertion() {
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertionsEnabled && !(LogManager.getLogManager() instanceof OLogManager.ShutdownLogManager);
    }

    private static void log(StringBuilder builder, Object from, String message, Throwable exception, Object ... args) {
        if (builder == null) {
            OLogManager.instance().error(from, message, exception, args);
        } else {
            String newLine = String.format("%n", new Object[0]);
            builder.append(String.format(message, args)).append(newLine);
            if (exception != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                builder.append(stringWriter.toString());
            }
        }
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    static {
        TRACK = OGlobalConfiguration.DIRECT_MEMORY_TRACK_MODE.getValueAsBoolean();
        Class<?> cleanerClass = null;
        Class<?> directBufferClass = null;
        Method cleanMethod = null;
        Method getCleanerMethod = null;
        Method attachmentMethod = null;
        try {
            cleanerClass = Class.forName("sun.misc.Cleaner");
            cleanMethod = cleanerClass.getDeclaredMethod("clean", new Class[0]);
            cleanMethod.setAccessible(true);
        }
        catch (ClassNotFoundException ignore) {
            cleanerClass = null;
            cleanMethod = null;
        }
        catch (NoSuchMethodException ignore) {
            cleanerClass = null;
            cleanMethod = null;
        }
        catch (SecurityException ignore) {
            cleanerClass = null;
            cleanMethod = null;
        }
        try {
            directBufferClass = Class.forName("sun.nio.ch.DirectBuffer");
            getCleanerMethod = directBufferClass.getDeclaredMethod("cleaner", new Class[0]);
            getCleanerMethod.setAccessible(true);
            attachmentMethod = directBufferClass.getDeclaredMethod("attachment", new Class[0]);
            attachmentMethod.setAccessible(true);
        }
        catch (ClassNotFoundException ignore) {
            directBufferClass = null;
            getCleanerMethod = null;
        }
        catch (NoSuchMethodException ignore) {
            directBufferClass = null;
            getCleanerMethod = null;
        }
        catch (SecurityException ignore) {
            directBufferClass = null;
            getCleanerMethod = null;
        }
        cleaner = cleanerClass;
        directBuffer = directBufferClass;
        getCleaner = getCleanerMethod;
        clean = cleanMethod;
        attachment = attachmentMethod;
    }

    private static class InstanceHolder {
        private static final OByteBufferPool INSTANCE;

        private InstanceHolder() {
        }

        static {
            OMemory.fixCommonConfigurationProblems();
            int pageSize = OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024;
            int memoryChunkSize = OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsInteger();
            long diskCacheSize = (long)OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsInteger() * 1024L * 1024L;
            INSTANCE = new OByteBufferPool(pageSize, memoryChunkSize, diskCacheSize);
        }
    }

    private static class TrackedBufferKey
    extends WeakReference<ByteBuffer> {
        private final int hashCode;

        public TrackedBufferKey(ByteBuffer referent) {
            super(referent);
            this.hashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            ByteBuffer buffer = (ByteBuffer)this.get();
            return buffer != null && buffer == ((TrackedBufferKey)obj).get();
        }
    }

    private static class TrackedBufferReference
    extends WeakReference<ByteBuffer> {
        public final int id;
        public final Exception stackTrace;

        public TrackedBufferReference(ByteBuffer referent, ReferenceQueue<? super ByteBuffer> q) {
            super(referent, q);
            this.id = OByteBufferPool.id(referent);
            this.stackTrace = new Exception();
        }
    }

    private static final class BufferHolder {
        private volatile ByteBuffer buffer;
        private final CountDownLatch latch = new CountDownLatch(1);

        private BufferHolder() {
        }
    }
}

