/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OOrderBy;
import com.orientechnologies.orient.core.sql.parser.OOrderByItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OSortedMultiIterator<T extends OIdentifiable>
implements Iterator<T> {
    private static final int STATUS_INIT = 0;
    private static final int STATUS_RUNNING = 1;
    private final OOrderBy orderBy;
    private List<Iterator<T>> sourceIterators = new ArrayList<Iterator<T>>();
    private List<T> heads = new ArrayList<T>();
    private int status = 0;

    public OSortedMultiIterator(OOrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public void add(Iterator<T> iterator) {
        if (this.status == 0) {
            this.sourceIterators.add(iterator);
            if (iterator.hasNext()) {
                this.heads.add(iterator.next());
            } else {
                this.heads.add(null);
            }
        } else {
            throw new IllegalStateException("You are trying to add a sub-iterator on a running OSortedMultiIterator");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.status == 0) {
            this.status = 1;
        }
        for (OIdentifiable o : this.heads) {
            if (o == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.status == 0) {
            this.status = 1;
        }
        int nextItemPosition = this.findNextPosition();
        OIdentifiable result = (OIdentifiable)this.heads.get(nextItemPosition);
        if (this.sourceIterators.get(nextItemPosition).hasNext()) {
            this.heads.set(nextItemPosition, this.sourceIterators.get(nextItemPosition).next());
        } else {
            this.heads.set(nextItemPosition, null);
        }
        return (T)result;
    }

    private int findNextPosition() {
        int lastPosition;
        for (lastPosition = 0; this.heads.size() < lastPosition && this.heads.get(lastPosition) == null; ++lastPosition) {
        }
        OIdentifiable lastItem = (OIdentifiable)this.heads.get(lastPosition);
        for (int i = lastPosition + 1; i < this.heads.size(); ++i) {
            OIdentifiable item = (OIdentifiable)this.heads.get(i);
            if (item == null || !this.comesFrist(item, lastItem)) continue;
            lastItem = item;
            lastPosition = i;
        }
        return lastPosition;
    }

    protected boolean comesFrist(T left, T right) {
        if (this.orderBy == null || this.orderBy.getItems() == null || this.orderBy.getItems().size() == 0) {
            return true;
        }
        if (right == null) {
            return true;
        }
        if (left == null) {
            return false;
        }
        ODocument leftDoc = left instanceof ODocument ? (ODocument)left : (ODocument)left.getRecord();
        ODocument rightDoc = right instanceof ODocument ? (ODocument)right : (ODocument)right.getRecord();
        for (OOrderByItem orderItem : this.orderBy.getItems()) {
            boolean greater;
            int compare;
            Object leftVal = leftDoc.field(orderItem.getRecordAttr());
            Object rightVal = rightDoc.field(orderItem.getRecordAttr());
            if (rightVal == null) {
                return true;
            }
            if (leftVal == null) {
                return false;
            }
            if (!(leftVal instanceof Comparable) || (compare = ((Comparable)leftVal).compareTo(rightVal)) == 0) continue;
            boolean bl = greater = compare > 0;
            if ("DESC".equals(orderItem.getType())) {
                return greater;
            }
            return !greater;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

