/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.jbake.app.ContentStore;
import org.jbake.model.DocumentTypeUtils;
import org.jbake.template.ModelExtractor;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.TemplateEngineAdapter;
import org.jbake.template.model.PublishedCustomExtractor;
import org.jbake.template.model.TypedDocumentsExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelExtractors {
    private static final String PROPERTIES = "META-INF/org.jbake.template.ModelExtractors.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelExtractors.class);
    private final Map<String, ModelExtractor> extractors = new TreeMap<String, ModelExtractor>();

    public static ModelExtractors getInstance() {
        return Loader.INSTANCE;
    }

    private ModelExtractors() {
        this.loadEngines();
    }

    public void reset() {
        this.extractors.clear();
        this.loadEngines();
    }

    public void registerEngine(String key, ModelExtractor extractor) {
        ModelExtractor old = this.extractors.put(key, extractor);
        if (old != null) {
            LOGGER.warn("Registered a model extractor for key [.{}] but another one was already defined: {}", (Object)key, (Object)old);
        }
    }

    private static ModelExtractor tryLoadEngine(String engineClassName) {
        try {
            Class<?> engineClass = Class.forName(engineClassName, false, ModelExtractors.class.getClassLoader());
            return (ModelExtractor)engineClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private void loadEngines() {
        try {
            ClassLoader cl = ModelExtractors.class.getClassLoader();
            Enumeration<URL> resources = cl.getResources(PROPERTIES);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties props = new Properties();
                props.load(url.openStream());
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String className = (String)entry.getKey();
                    String[] extensions = ((String)entry.getValue()).split(",");
                    this.loadAndRegisterEngine(className, extensions);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadAndRegisterEngine(String className, String ... extensions) {
        ModelExtractor engine = ModelExtractors.tryLoadEngine(className);
        if (engine != null) {
            for (String extension : extensions) {
                this.registerEngine(extension, engine);
            }
        }
    }

    public <Type> Type extractAndTransform(ContentStore db, String key, Map map, TemplateEngineAdapter<Type> adapter) throws NoModelExtractorException {
        if (this.extractors.containsKey(key)) {
            Object extractedValue = this.extractors.get(key).get(db, map, key);
            return adapter.adapt(key, extractedValue);
        }
        throw new NoModelExtractorException("no model extractor for key \"" + key + "\"");
    }

    public boolean containsKey(Object key) {
        return this.extractors.containsKey(key);
    }

    public Set<String> keySet() {
        return this.extractors.keySet();
    }

    public void registerExtractorsForCustomTypes(String docType) {
        String pluralizedDoctype = DocumentTypeUtils.pluralize(docType);
        if (!this.containsKey(pluralizedDoctype)) {
            LOGGER.info("register new extractors for document type: {}", (Object)docType);
            this.registerEngine(pluralizedDoctype, new TypedDocumentsExtractor());
            this.registerEngine("published_" + pluralizedDoctype, new PublishedCustomExtractor(docType));
        }
    }

    private static class Loader {
        private static final ModelExtractors INSTANCE = new ModelExtractors();

        private Loader() {
        }
    }
}

