/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.jbake.app.configuration.DefaultJBakeConfiguration;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.parser.ParserContext;
import org.jbake.parser.ParserEngine;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupEngine
implements ParserEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkupEngine.class);
    private static final String UTF_8_BOM = "\ufeff";
    private JBakeConfiguration configuration;

    public boolean validate(ParserContext context) {
        return true;
    }

    public void processHeader(ParserContext context) {
    }

    public void processBody(ParserContext context) {
    }

    @Override
    public Map<String, Object> parse(Configuration config, File file, String contentPath) {
        return this.parse(new DefaultJBakeConfiguration((CompositeConfiguration)config), file);
    }

    @Override
    public Map<String, Object> parse(JBakeConfiguration config, File file) {
        List fileContents;
        this.configuration = config;
        try (FileInputStream is = new FileInputStream(file);){
            fileContents = IOUtils.readLines((InputStream)is, (String)config.getRenderEncoding());
        }
        catch (IOException e) {
            LOGGER.error("Error while opening file {}", (Object)file, (Object)e);
            return null;
        }
        boolean hasHeader = this.hasHeader(fileContents);
        ParserContext context = new ParserContext(file, fileContents, config, hasHeader);
        if (hasHeader) {
            this.processDefaultHeader(context);
        }
        this.processHeader(context);
        this.setModelDefaultsIfNotSetInHeader(context);
        this.sanitizeTags(context);
        if (context.getType().isEmpty() || context.getStatus().isEmpty()) {
            LOGGER.warn("Parsing skipped (missing type or status value in header meta data) for file {}!", (Object)file);
            return null;
        }
        this.processDefaultBody(context);
        if (!this.validate(context)) {
            LOGGER.error("Incomplete source file ({}) for markup engine: {}", (Object)file, (Object)this.getClass().getSimpleName());
            return null;
        }
        this.processBody(context);
        return context.getDocumentModel();
    }

    private void sanitizeTags(ParserContext context) {
        if (context.getTags() != null) {
            String[] tags = (String[])context.getTags();
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = this.sanitizeValue(tags[i]);
                if (!context.getConfig().getSanitizeTag()) continue;
                tags[i] = tags[i].replace(" ", "-");
            }
            context.setTags(tags);
        }
    }

    private void setModelDefaultsIfNotSetInHeader(ParserContext context) {
        if (context.getDate() == null) {
            context.setDate(new Date(context.getFile().lastModified()));
        }
        if (context.getConfig().getDefaultStatus() != null && context.getStatus().isEmpty()) {
            context.setDefaultStatus();
        }
        if (context.getConfig().getDefaultType() != null && context.getType().isEmpty()) {
            context.setDefaultType();
        }
    }

    private boolean hasHeader(List<String> contents) {
        boolean headerValid = true;
        boolean statusFound = false;
        boolean typeFound = false;
        if (!this.headerSeparatorDemarcatesHeader(contents)) {
            return false;
        }
        for (String line : contents) {
            if (this.hasHeaderSeparator(line)) {
                LOGGER.debug("Header separator found");
                break;
            }
            if (this.isTypeProperty(line)) {
                LOGGER.debug("Type property found");
                typeFound = true;
            }
            if (this.isStatusProperty(line)) {
                LOGGER.debug("Status property found");
                statusFound = true;
            }
            if (line.isEmpty() || line.contains("=")) continue;
            LOGGER.error("Property found without assignment [{}]", (Object)line);
            headerValid = false;
        }
        return !(!headerValid || !statusFound && !this.hasDefaultStatus() || !typeFound && !this.hasDefaultType());
    }

    private boolean hasDefaultType() {
        return !this.configuration.getDefaultType().isEmpty();
    }

    private boolean hasDefaultStatus() {
        return !this.configuration.getDefaultStatus().isEmpty();
    }

    private boolean hasHeaderSeparatorInContent(List<String> contents) {
        return contents.indexOf(this.configuration.getHeaderSeparator()) != -1;
    }

    private boolean headerSeparatorDemarcatesHeader(List<String> contents) {
        List<String> subContents = null;
        int index = contents.indexOf(this.configuration.getHeaderSeparator());
        if (index != -1) {
            subContents = contents.subList(0, index);
            for (String line : subContents) {
                if (line.contains("=") || line.isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasHeaderSeparator(String line) {
        return line.equals(this.configuration.getHeaderSeparator());
    }

    private boolean isStatusProperty(String line) {
        return line.startsWith("status=");
    }

    private boolean isTypeProperty(String line) {
        return line.startsWith("type=");
    }

    private void processDefaultHeader(ParserContext context) {
        for (String line : context.getFileLines()) {
            if (this.hasHeaderSeparator(line)) break;
            this.processHeaderLine(line, context.getDocumentModel());
        }
    }

    private void processHeaderLine(String line, Map<String, Object> content) {
        String[] parts = line.split("=", 2);
        if (!line.isEmpty() && parts.length == 2) {
            this.storeHeaderValue(parts[0], parts[1], content);
        }
    }

    void storeHeaderValue(String inputKey, String inputValue, Map<String, Object> content) {
        String key = this.sanitizeKey(inputKey);
        String value = this.sanitizeValue(inputValue);
        if (key.equalsIgnoreCase("date")) {
            SimpleDateFormat df = new SimpleDateFormat(this.configuration.getDateFormat());
            try {
                Date date = df.parse(value);
                content.put(key, date);
            }
            catch (ParseException e) {
                LOGGER.error("unable to parse date {}", (Object)value);
            }
        } else if (key.equalsIgnoreCase("tags")) {
            content.put(key, this.getTags(value));
        } else if (this.isJson(value)) {
            content.put(key, JSONValue.parse((String)value));
        } else {
            content.put(key, value);
        }
    }

    private String sanitizeValue(String part) {
        return part.trim();
    }

    private String sanitizeKey(String part) {
        String key = part.contains(UTF_8_BOM) ? part.trim().replace(UTF_8_BOM, "") : part.trim();
        return key;
    }

    private String[] getTags(String tagsPart) {
        String[] tags = tagsPart.split(",");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = this.sanitizeValue(tags[i]);
        }
        return tags;
    }

    private boolean isJson(String part) {
        return part.startsWith("{") && part.endsWith("}");
    }

    private void processDefaultBody(ParserContext context) {
        StringBuilder body = new StringBuilder();
        boolean inBody = false;
        for (String line : context.getFileLines()) {
            if (inBody) {
                body.append(line).append("\n");
            }
            if (!line.equals(this.configuration.getHeaderSeparator())) continue;
            inBody = true;
        }
        if (body.length() == 0) {
            for (String line : context.getFileLines()) {
                body.append(line).append("\n");
            }
        }
        context.setBody(body.toString());
    }
}

