/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.jbake.app.configuration.JBakeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJBakeConfiguration
implements JBakeConfiguration {
    private static final String SOURCE_FOLDER_KEY = "sourceFolder";
    private static final String DESTINATION_FOLDER_KEY = "destinationFolder";
    private static final String ASSET_FOLDER_KEY = "assetFolder";
    private static final String TEMPLATE_FOLDER_KEY = "templateFolder";
    private static final String CONTENT_FOLDER_KEY = "contentFolder";
    private static final Pattern TEMPLATE_DOC_PATTERN = Pattern.compile("(?:template\\.)([a-zA-Z0-9-_]+)(?:\\.file)");
    private static final String DOCTYPE_FILE_POSTFIX = ".file";
    private static final String DOCTYPE_EXTENSION_POSTFIX = ".extension";
    private static final String DOCTYPE_TEMPLATE_PREFIX = "template.";
    private Logger logger = LoggerFactory.getLogger(DefaultJBakeConfiguration.class);
    private CompositeConfiguration compositeConfiguration;

    @Deprecated
    public DefaultJBakeConfiguration(CompositeConfiguration configuration) {
        this.compositeConfiguration = configuration;
    }

    public DefaultJBakeConfiguration(File sourceFolder, CompositeConfiguration configuration) {
        this.compositeConfiguration = configuration;
        this.setSourceFolder(sourceFolder);
        this.setupDefaultDestination();
        this.setupPathsRelativeToSourceFile();
    }

    @Override
    public Object get(String key) {
        return this.compositeConfiguration.getProperty(key);
    }

    @Override
    public String getArchiveFileName() {
        return this.getAsString("archive.file");
    }

    private boolean getAsBoolean(String key) {
        return this.compositeConfiguration.getBoolean(key, false);
    }

    private File getAsFolder(String key) {
        return (File)this.get(key);
    }

    private int getAsInt(String key, int defaultValue) {
        return this.compositeConfiguration.getInt(key, defaultValue);
    }

    private List<String> getAsList(String key) {
        return Arrays.asList(this.compositeConfiguration.getStringArray(key));
    }

    private String getAsString(String key) {
        return this.compositeConfiguration.getString(key);
    }

    private String getAsString(String key, String defaultValue) {
        return this.compositeConfiguration.getString(key, defaultValue);
    }

    @Override
    public List<String> getAsciidoctorAttributes() {
        return this.getAsList("asciidoctor.attributes");
    }

    @Override
    public Object getAsciidoctorOption(String optionKey) {
        Configuration subConfig = this.compositeConfiguration.subset("asciidoctor.option");
        Object value = subConfig.getProperty(optionKey);
        if (value == null) {
            this.logger.warn("Cannot find asciidoctor option '{}.{}'", (Object)"asciidoctor.option", (Object)optionKey);
            return "";
        }
        return value;
    }

    @Override
    public List<String> getAsciidoctorOptionKeys() {
        ArrayList<String> options = new ArrayList<String>();
        Configuration subConfig = this.compositeConfiguration.subset("asciidoctor.option");
        Iterator iterator = subConfig.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            options.add(key);
        }
        return options;
    }

    @Override
    public File getAssetFolder() {
        return this.getAsFolder(ASSET_FOLDER_KEY);
    }

    public void setAssetFolder(File assetFolder) {
        if (assetFolder != null) {
            this.setProperty(ASSET_FOLDER_KEY, assetFolder);
            this.setProperty("asset.folder", assetFolder.getName());
        }
    }

    @Override
    public String getAssetFolderName() {
        return this.getAsString("asset.folder");
    }

    @Override
    public boolean getAssetIgnoreHidden() {
        return this.getAsBoolean("asset.ignore");
    }

    public void setAssetIgnoreHidden(boolean assetIgnoreHidden) {
        this.setProperty("asset.ignore", assetIgnoreHidden);
    }

    @Override
    public String getAttributesExportPrefixForAsciidoctor() {
        return this.getAsString("asciidoctor.attributes.export.prefix", "");
    }

    @Override
    public String getBuildTimeStamp() {
        return this.getAsString("build.timestamp");
    }

    @Override
    public boolean getClearCache() {
        return this.getAsBoolean("db.clear.cache");
    }

    public void setClearCache(boolean clearCache) {
        this.setProperty("db.clear.cache", clearCache);
    }

    public CompositeConfiguration getCompositeConfiguration() {
        return this.compositeConfiguration;
    }

    public void setCompositeConfiguration(CompositeConfiguration configuration) {
        this.compositeConfiguration = configuration;
    }

    @Override
    public File getContentFolder() {
        return this.getAsFolder(CONTENT_FOLDER_KEY);
    }

    public void setContentFolder(File contentFolder) {
        if (contentFolder != null) {
            this.setProperty(CONTENT_FOLDER_KEY, contentFolder);
            this.setProperty("content.folder", contentFolder.getName());
        }
    }

    @Override
    public String getContentFolderName() {
        return this.getAsString("content.folder");
    }

    @Override
    public String getDatabasePath() {
        return this.getAsString("db.path");
    }

    public void setDatabasePath(String path) {
        this.setProperty("db.path", path);
    }

    @Override
    public String getDatabaseStore() {
        return this.getAsString("db.store");
    }

    public void setDatabaseStore(String storeType) {
        this.setProperty("db.store", storeType);
    }

    @Override
    public String getDateFormat() {
        return this.getAsString("date.format");
    }

    @Override
    public String getDefaultStatus() {
        return this.getAsString("default.status", "");
    }

    public void setDefaultStatus(String status) {
        this.setProperty("default.status", status);
    }

    @Override
    public String getDefaultType() {
        return this.getAsString("default.type", "");
    }

    public void setDefaultType(String type) {
        this.setProperty("default.type", type);
    }

    @Override
    public File getDestinationFolder() {
        return this.getAsFolder(DESTINATION_FOLDER_KEY);
    }

    @Override
    public void setDestinationFolder(File destinationFolder) {
        if (destinationFolder != null) {
            this.setProperty(DESTINATION_FOLDER_KEY, destinationFolder);
            this.setProperty("destination.folder", destinationFolder.getName());
        }
    }

    @Override
    public List<String> getDocumentTypes() {
        ArrayList<String> docTypes = new ArrayList<String>();
        Iterator keyIterator = this.compositeConfiguration.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Matcher matcher = TEMPLATE_DOC_PATTERN.matcher(key);
            if (!matcher.find()) continue;
            docTypes.add(matcher.group(1));
        }
        return docTypes;
    }

    @Override
    public String getDraftSuffix() {
        return this.getAsString("draft.suffix", "");
    }

    @Override
    public String getExampleProjectByType(String templateType) {
        return this.getAsString("example.project." + templateType);
    }

    @Override
    public boolean getExportAsciidoctorAttributes() {
        return this.getAsBoolean("asciidoctor.attributes.export");
    }

    @Override
    public String getFeedFileName() {
        return this.getAsString("feed.file");
    }

    @Override
    public String getIndexFileName() {
        return this.getAsString("index.file");
    }

    @Override
    public Iterator<String> getKeys() {
        return this.compositeConfiguration.getKeys();
    }

    @Override
    public List<String> getMarkdownExtensions() {
        return this.getAsList("markdown.extensions");
    }

    public void setMarkdownExtensions(String ... extensions) {
        this.setProperty("markdown.extensions", StringUtils.join((Object[])extensions, (String)","));
    }

    @Override
    public String getOutputExtension() {
        return this.getAsString("output.extension");
    }

    public void setOutputExtension(String outputExtension) {
        this.setProperty("output.extension", outputExtension);
    }

    @Override
    public String getOutputExtensionByDocType(String docType) {
        String templateExtensionKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_EXTENSION_POSTFIX;
        String defaultOutputExtension = this.getOutputExtension();
        return this.getAsString(templateExtensionKey, defaultOutputExtension);
    }

    @Override
    public boolean getPaginateIndex() {
        return this.getAsBoolean("index.paginate");
    }

    public void setPaginateIndex(boolean paginateIndex) {
        this.setProperty("index.paginate", paginateIndex);
    }

    @Override
    public int getPostsPerPage() {
        return this.getAsInt("index.posts_per_page", 5);
    }

    public void setPostsPerPage(int postsPerPage) {
        this.setProperty("index.posts_per_page", postsPerPage);
    }

    @Override
    public String getPrefixForUriWithoutExtension() {
        return this.getAsString("uri.noExtension.prefix");
    }

    public void setPrefixForUriWithoutExtension(String prefix) {
        this.setProperty("uri.noExtension.prefix", prefix);
    }

    @Override
    public boolean getRenderArchive() {
        return this.getAsBoolean("render.archive");
    }

    @Override
    public String getRenderEncoding() {
        return this.getAsString("render.encoding");
    }

    @Override
    public boolean getRenderFeed() {
        return this.getAsBoolean("render.feed");
    }

    @Override
    public boolean getRenderIndex() {
        return this.getAsBoolean("render.index");
    }

    @Override
    public boolean getRenderSiteMap() {
        return this.getAsBoolean("render.sitemap");
    }

    @Override
    public boolean getRenderTags() {
        return this.getAsBoolean("render.tags");
    }

    @Override
    public boolean getRenderTagsIndex() {
        return this.compositeConfiguration.getBoolean("render.tagsindex", false);
    }

    public void setRenderTagsIndex(boolean enable) {
        this.compositeConfiguration.setProperty("render.tagsindex", (Object)enable);
    }

    @Override
    public boolean getSanitizeTag() {
        return this.getAsBoolean("tag.sanitize");
    }

    @Override
    public int getServerPort() {
        return this.getAsInt("server.port", 8080);
    }

    public void setServerPort(int port) {
        this.setProperty("server.port", port);
    }

    @Override
    public String getSiteHost() {
        return this.getAsString("site.host", "http://www.jbake.org");
    }

    public void setSiteHost(String siteHost) {
        this.setProperty("site.host", siteHost);
    }

    @Override
    public String getSiteMapFileName() {
        return this.getAsString("sitemap.file");
    }

    @Override
    public File getSourceFolder() {
        return this.getAsFolder(SOURCE_FOLDER_KEY);
    }

    public void setSourceFolder(File sourceFolder) {
        this.setProperty(SOURCE_FOLDER_KEY, sourceFolder);
        this.setupPathsRelativeToSourceFile();
    }

    @Override
    public String getTagPathName() {
        return this.getAsString("tag.path");
    }

    @Override
    public String getTemplateEncoding() {
        return this.getAsString("template.encoding");
    }

    @Override
    public File getTemplateFileByDocType(String docType) {
        String templateKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_FILE_POSTFIX;
        String templateFileName = this.getAsString(templateKey);
        if (templateFileName != null) {
            return new File(this.getTemplateFolder(), templateFileName);
        }
        this.logger.warn("Cannot find configuration key '{}' for document type '{}'", (Object)templateKey, (Object)docType);
        return null;
    }

    @Override
    public File getTemplateFolder() {
        return this.getAsFolder(TEMPLATE_FOLDER_KEY);
    }

    public void setTemplateFolder(File templateFolder) {
        if (templateFolder != null) {
            this.setProperty(TEMPLATE_FOLDER_KEY, templateFolder);
            this.setProperty("template.folder", templateFolder.getName());
        }
    }

    @Override
    public String getTemplateFolderName() {
        return this.getAsString("template.folder");
    }

    @Override
    public String getThymeleafLocale() {
        return this.getAsString("thymeleaf.locale");
    }

    @Override
    public boolean getUriWithoutExtension() {
        return this.getAsBoolean("uri.noExtension");
    }

    public void setUriWithoutExtension(boolean withoutExtension) {
        this.setProperty("uri.noExtension", withoutExtension);
    }

    @Override
    public String getVersion() {
        return this.getAsString("version");
    }

    public void setDestinationFolderName(String folderName) {
        this.setProperty("destination.folder", folderName);
        this.setupDefaultDestination();
    }

    public void setExampleProject(String type, String fileName) {
        String projectKey = "example.project." + type;
        this.setProperty(projectKey, fileName);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.compositeConfiguration.setProperty(key, value);
    }

    public void setTemplateExtensionForDocType(String docType, String extension) {
        String templateExtensionKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_EXTENSION_POSTFIX;
        this.setProperty(templateExtensionKey, extension);
    }

    public void setTemplateFileNameForDocType(String docType, String fileName) {
        String templateKey = DOCTYPE_TEMPLATE_PREFIX + docType + DOCTYPE_FILE_POSTFIX;
        this.setProperty(templateKey, fileName);
    }

    private void setupDefaultAssetFolder() {
        String assetFolder = this.getAsString("asset.folder");
        this.setAssetFolder(new File(this.getSourceFolder(), assetFolder));
    }

    private void setupDefaultContentFolder() {
        this.setContentFolder(new File(this.getSourceFolder(), this.getContentFolderName()));
    }

    private void setupDefaultDestination() {
        String destinationPath = this.getAsString("destination.folder");
        this.setDestinationFolder(new File(this.getSourceFolder(), destinationPath));
    }

    private void setupDefaultTemplateFolder() {
        String destinationPath = this.getAsString("template.folder");
        this.setTemplateFolder(new File(this.getSourceFolder(), destinationPath));
    }

    private void setupPathsRelativeToSourceFile() {
        this.setupDefaultAssetFolder();
        this.setupDefaultTemplateFolder();
        this.setupDefaultContentFolder();
    }

    @Override
    public String getHeaderSeparator() {
        return this.getAsString("header.separator");
    }

    public void setHeaderSeparator(String headerSeparator) {
        this.setProperty("header.separator", headerSeparator);
    }

    @Override
    public boolean getImgPathPrependHost() {
        return this.getAsBoolean("img.path.prepend.host");
    }

    public void setImgPathPrependHost(boolean imgPathPrependHost) {
        this.setProperty("img.path.prepend.host", imgPathPrependHost);
    }

    @Override
    public boolean getImgPathUpdate() {
        return this.getAsBoolean("img.path.update");
    }

    public void setImgPathUPdate(boolean imgPathUpdate) {
        this.setProperty("img.path.update", imgPathUpdate);
    }
}

