/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.jbake.app.FileUtil;
import org.jbake.app.configuration.JBakeConfiguration;
import org.jbake.app.configuration.JBakeConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asset {
    private static final Logger LOGGER = LoggerFactory.getLogger(Asset.class);
    private final List<Throwable> errors = new LinkedList<Throwable>();
    private JBakeConfiguration config;

    @Deprecated
    public Asset(File source, File destination, CompositeConfiguration config) {
        this.config = new JBakeConfigurationFactory().createDefaultJbakeConfiguration(source, destination, config);
    }

    public Asset(JBakeConfiguration config) {
        this.config = config;
    }

    public void copy() {
        this.copy(this.config.getAssetFolder());
    }

    public void copy(File path) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !(Asset.this.config.getAssetIgnoreHidden() && file.isHidden() || !file.isFile() && !FileUtil.directoryOnlyIfNotIgnored(file));
            }
        };
        this.copy(path, this.config.getDestinationFolder(), filter);
    }

    public void copySingleFile(File asset) {
        try {
            if (!asset.isDirectory()) {
                String targetPath = this.config.getDestinationFolder().getCanonicalPath() + File.separatorChar + this.assetSubPath(asset);
                LOGGER.info("Copying single asset file to [{}]", (Object)targetPath);
                this.copyFile(asset, new File(targetPath));
            } else {
                LOGGER.info("Skip copying single asset file [{}]. Is a directory.", (Object)asset.getPath());
            }
        }
        catch (IOException io) {
            LOGGER.error("Failed to copy the asset file.", (Throwable)io);
        }
    }

    public boolean isAssetFile(File path) {
        boolean isAsset = false;
        try {
            if (FileUtil.directoryOnlyIfNotIgnored(path.getParentFile())) {
                if (FileUtil.isFileInDirectory(path, this.config.getAssetFolder())) {
                    isAsset = true;
                } else if (FileUtil.isFileInDirectory(path, this.config.getContentFolder()) && FileUtil.getNotContentFileFilter().accept(path)) {
                    isAsset = true;
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Unable to determine the path to asset file {}", (Object)path.getPath(), (Object)ioe);
        }
        return isAsset;
    }

    public void copyAssetsFromContent(File path) {
        this.copy(path, this.config.getDestinationFolder(), FileUtil.getNotContentFileFilter());
    }

    public List<Throwable> getErrors() {
        return new ArrayList<Throwable>(this.errors);
    }

    private String assetSubPath(File asset) throws IOException {
        String targetFolder = asset.getCanonicalPath().replace(this.config.getAssetFolder().getCanonicalPath() + File.separatorChar, "");
        targetFolder = targetFolder.replace(this.config.getContentFolder().getCanonicalPath() + File.separatorChar, "");
        return targetFolder;
    }

    private void copy(File sourceFolder, File targetFolder, FileFilter filter) {
        Object[] assets = sourceFolder.listFiles(filter);
        if (assets != null) {
            Arrays.sort(assets);
            for (Object asset : assets) {
                File target = new File(targetFolder, ((File)asset).getName());
                if (((File)asset).isFile()) {
                    this.copyFile((File)asset, target);
                    continue;
                }
                if (!((File)asset).isDirectory()) continue;
                this.copy((File)asset, target, filter);
            }
        }
    }

    private void copyFile(File asset, File targetFolder) {
        try {
            FileUtils.copyFile((File)asset, (File)targetFolder);
            LOGGER.info("Copying [{}]... done!", (Object)asset.getPath());
        }
        catch (IOException e) {
            LOGGER.error("Copying [{}]... failed!", (Object)asset.getPath(), (Object)e);
            this.errors.add(e);
        }
    }
}

