/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.Ref;
import com.vladsch.flexmark.util.html.ConditionalFormatter;
import com.vladsch.flexmark.util.html.FormattingAppendable;
import com.vladsch.flexmark.util.html.LengthTrackingAppendable;
import com.vladsch.flexmark.util.html.LengthTrackingAppendableImpl;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.CharSubSequence;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class FormattingAppendableImpl
implements FormattingAppendable {
    private final LengthTrackingAppendable myAppendable;
    private final Stack<ConditionalFrame> myConditionalFrames;
    private final Stack<Integer> myIndentLineCounts;
    private final char myEOL;
    private final ArrayList<Ref<Integer>> myOffsetBeforeList;
    private final HashMap<Integer, List<Runnable>> myAfterEolRunnables;
    private String myWhitespace;
    private String myWhitespaceEOL;
    private int myOptions;
    private int myEolOptions;
    private IOException myIOException;
    private int myModCount;
    private int myOffsetBefore;
    private int myPendingEOL;
    private boolean myPendingPreFormattedPrefix;
    private int myLineCount;
    private int myModCountOfLastEOL;
    private int myLastEOLCount;
    private int myLastEOLOffset;
    private int myIndent;
    private boolean myWillIndent;
    private int myIndentOffset;
    private BasedSequence myPrefix;
    private BasedSequence myIndentPrefix;
    private int mySpacesAfterEOL;
    private int myPreFormattedNesting;
    private int myPendingSpaces;
    private final Stack<BasedSequence> myPrefixStack;
    private boolean myPassThrough;

    public FormattingAppendableImpl(int formatOptions) {
        this(new StringBuilder(), formatOptions);
    }

    public FormattingAppendableImpl(Appendable appendable, int formatOptions) {
        this.myAppendable = new LengthTrackingAppendableImpl(appendable);
        this.myConditionalFrames = new Stack();
        this.myIndentLineCounts = new Stack();
        this.myPrefixStack = new Stack();
        this.myOffsetBeforeList = new ArrayList();
        this.myAfterEolRunnables = new HashMap();
        this.myEOL = (char)10;
        this.myOptions = formatOptions;
        this.myIOException = null;
        this.myModCount = 0;
        this.myOffsetBefore = 0;
        this.myPendingEOL = 0;
        this.myPendingPreFormattedPrefix = false;
        this.myLineCount = 0;
        this.myModCountOfLastEOL = 0;
        this.myLastEOLCount = 0;
        this.myIndent = 0;
        this.myWillIndent = false;
        this.myIndentOffset = 0;
        this.myPrefix = BasedSequence.NULL;
        this.myIndentPrefix = BasedSequence.NULL;
        this.myPreFormattedNesting = 0;
        this.myEolOptions = this.myOptions;
        this.mySpacesAfterEOL = 0;
        this.myPassThrough = this.haveOptions(16);
        this.updateLastEolOffset();
        this.setWhitespace();
    }

    private void setWhitespace() {
        this.myWhitespace = this.isConvertingTabs() ? " \t" : " ";
        this.myWhitespaceEOL = this.isConvertingTabs() ? " \t\r\n" : " \n";
    }

    @Override
    public int getOptions() {
        return this.myOptions;
    }

    @Override
    public FormattingAppendable setOptions(int options) {
        this.myOptions = options;
        this.myPassThrough = this.haveOptions(16);
        this.setWhitespace();
        return this;
    }

    private boolean haveOptions(int options) {
        return (this.myOptions & options) != 0;
    }

    private boolean haveEolOptions(int options) {
        return (this.myEolOptions & options) != 0;
    }

    private boolean isConvertingTabs() {
        return this.haveOptions(3);
    }

    private boolean isSuppressingTrailingWhitespace() {
        return this.haveOptions(4);
    }

    private boolean isAllowLeadingWhitespace() {
        return this.haveOptions(32);
    }

    private boolean isCollapseWhitespace() {
        return this.haveOptions(2);
    }

    private boolean isPrefixAfterPendingEol() {
        return this.haveOptions(8);
    }

    private void appendIndent() throws IOException {
        if (!this.myPrefix.isEmpty()) {
            this.myAppendable.append(this.myPrefix);
        }
        if (this.myIndent + this.myIndentOffset > 0 && !this.myIndentPrefix.isEmpty()) {
            for (int i = 0; i < this.myIndent + this.myIndentOffset; ++i) {
                this.myAppendable.append(this.myIndentPrefix);
            }
        }
    }

    private void addPendingSpaces(int count) {
        if (count > 0 && this.myPreFormattedNesting == 0 && (this.myPendingEOL == 0 && this.myModCountOfLastEOL != this.myModCount || this.isAllowLeadingWhitespace())) {
            if (this.isCollapseWhitespace()) {
                if (this.myPendingSpaces == 0) {
                    this.myPendingSpaces = 1;
                }
            } else {
                this.myPendingSpaces += count;
            }
        }
    }

    private void appendSpaces() throws IOException {
        if (this.myPendingSpaces > 0) {
            int spaces = this.myPendingSpaces;
            this.appendSpaces(spaces);
            this.myPendingSpaces = 0;
            ++this.myModCount;
        }
    }

    private void appendSpaces(int spaces) throws IOException {
        while (spaces > 0) {
            this.myAppendable.append(' ');
            --spaces;
        }
    }

    private void setPendingEOL(int pendingEOL) {
        if (this.myPassThrough) {
            if (this.myAppendable.getLength() > 0) {
                this.myPendingEOL = pendingEOL;
            }
        } else if (this.myPreFormattedNesting == 0 && pendingEOL > this.myPendingEOL) {
            if (this.myModCountOfLastEOL != this.myModCount) {
                this.myPendingEOL = pendingEOL;
                this.myEolOptions = this.myOptions;
            } else if (this.myLineCount > 0 && pendingEOL > this.myLastEOLCount) {
                this.myPendingEOL = pendingEOL - this.myLastEOLCount;
                this.myEolOptions = this.myOptions;
            }
        }
        this.mySpacesAfterEOL = 0;
    }

    private void resetPendingEOL() {
        this.myPendingEOL = 0;
        this.myPendingSpaces = 0;
        this.myModCountOfLastEOL = this.myModCount;
        this.myEolOptions = this.myOptions;
    }

    @Override
    public FormattingAppendableImpl addAfterEolRunnable(int atPendingEOL, Runnable runnable) {
        List<Runnable> runnableList = this.myAfterEolRunnables.get(atPendingEOL);
        if (runnableList == null) {
            runnableList = new ArrayList<Runnable>();
            this.myAfterEolRunnables.put(atPendingEOL, runnableList);
        }
        runnableList.add(runnable);
        return this;
    }

    private void runAllAfterEol() {
        List<Runnable> runnableList = this.myAfterEolRunnables.get(this.myPendingEOL);
        if (runnableList != null) {
            for (Runnable runnable : runnableList) {
                runnable.run();
            }
            this.myAfterEolRunnables.remove(this.myPendingEOL);
        }
    }

    private void appendEOL(boolean withIndent, boolean withPendingSpaces) throws IOException {
        int lineCount = this.myLineCount;
        if (this.myPendingEOL > 0) {
            if (this.myPendingSpaces > 0 && !this.haveEolOptions(4)) {
                this.appendSpaces();
            }
            while (this.myPendingEOL > 0) {
                this.myAppendable.append(this.myEOL);
                this.updateLastEolOffset();
                ++this.myLineCount;
                this.runAllAfterEol();
                --this.myPendingEOL;
                if (this.myPendingEOL <= 0 || this.myPrefix.isBlank()) continue;
                this.myAppendable.append(this.myPrefix);
            }
            this.resetPendingEOL();
            this.runAllAfterEol();
            this.appendSpaces(this.mySpacesAfterEOL);
            this.mySpacesAfterEOL = 0;
            if (withIndent) {
                this.appendIndent();
            }
        } else if (this.myModCountOfLastEOL == this.myModCount) {
            if (this.isAllowLeadingWhitespace() && withPendingSpaces) {
                this.appendSpaces();
            }
            if (withIndent) {
                this.appendIndent();
            }
        } else if (withPendingSpaces) {
            this.appendSpaces();
        }
        this.myLastEOLCount = this.myLineCount - lineCount;
    }

    private void updateLastEolOffset() {
        this.myLastEOLOffset = this.myAppendable.getLength();
    }

    private void beforeAppendText(boolean withEOL, boolean withIndent, boolean withSpaces) throws IOException {
        this.myLastEOLCount = 0;
        if (this.myConditionalFrames.size() > 0) {
            ConditionalFrame frame = this.myConditionalFrames.peek();
            if (!frame.myInFormatter) {
                boolean firstApply;
                boolean bl = firstApply = frame.myModCount == this.myModCount;
                if (firstApply) {
                    ++this.myModCount;
                }
                if (firstApply || !frame.myOnIndent && (this.myWillIndent || frame.myIndent < this.myIndent)) {
                    frame.myInFormatter = true;
                    frame.myOnIndent = this.myWillIndent || frame.myIndent < this.myIndent;
                    frame.myOnLine = frame.myLineCount < this.myLineCount + this.myPendingEOL;
                    int indent = this.myIndent;
                    this.myIndent = frame.myIndent;
                    this.myPendingEOL = 0;
                    this.runAllAfterEol();
                    int lineCount = this.myLineCount;
                    frame.myOpenFormatter.apply(firstApply, frame.myOnIndent, frame.myOnLine, true);
                    this.myIndent += indent - frame.myIndent;
                    if (frame.myLineRef != null && firstApply) {
                        frame.myLineRef.value = lineCount != this.myLineCount;
                    }
                    frame.myInFormatter = false;
                }
            }
        }
        if (withEOL) {
            this.appendEOL(withIndent, withSpaces);
        } else if (withSpaces) {
            this.appendSpaces();
        }
    }

    private void setOffsetBefore(int offsetBefore) {
        this.myOffsetBefore = offsetBefore;
        if (!this.myOffsetBeforeList.isEmpty()) {
            for (Ref<Integer> refOffset : this.myOffsetBeforeList) {
                refOffset.value = offsetBefore;
            }
            this.myOffsetBeforeList.clear();
        }
    }

    private void beforePre() throws IOException {
        while (this.myPendingEOL > 0) {
            this.myAppendable.append('\n');
            this.updateLastEolOffset();
            ++this.myLineCount;
            if (this.myPendingPreFormattedPrefix && !this.myPrefix.isEmpty()) {
                this.myAppendable.append(this.myPrefix);
            }
            --this.myPendingEOL;
        }
        this.myPendingPreFormattedPrefix = false;
    }

    private void appendImpl(char c) throws IOException {
        if (this.myPassThrough) {
            if (this.myPendingEOL-- > 0) {
                this.myAppendable.append('\n');
            }
            this.myPendingEOL = 0;
            ++this.myModCount;
            this.myAppendable.append(c);
            return;
        }
        if (this.myPreFormattedNesting > 0) {
            this.setOffsetBefore(this.myAppendable.getLength());
            this.beforePre();
            if (this.myPendingPreFormattedPrefix && !this.myPrefix.isEmpty()) {
                this.myAppendable.append(this.myPrefix);
            }
            this.myPendingPreFormattedPrefix = false;
            if (c == this.myEOL) {
                this.myPendingEOL = 1;
                this.myPendingPreFormattedPrefix = true;
                this.mySpacesAfterEOL = 0;
            } else {
                this.myAppendable.append(c);
                ++this.myModCount;
                this.resetPendingEOL();
            }
        } else if (c == this.myEOL) {
            this.setPendingEOL(1);
        } else if (this.myWhitespace.indexOf(c) != -1) {
            this.addPendingSpaces(1);
        } else {
            this.beforeAppendText(true, true, true);
            this.setOffsetBefore(this.myAppendable.getLength());
            this.myAppendable.append(c);
            ++this.myModCount;
        }
    }

    private void appendImpl(CharSequence csq, int start, int end) throws IOException {
        if (this.myPassThrough) {
            if (this.myPendingEOL-- > 0) {
                this.myAppendable.append('\n');
            }
            this.myPendingEOL = 0;
            ++this.myModCount;
            this.myAppendable.append(csq, start, end);
            return;
        }
        int lastPos = start;
        BasedSequence seq = BasedSequenceImpl.of(csq);
        if (this.myPreFormattedNesting > 0) {
            this.setOffsetBefore(this.myAppendable.getLength());
            int endNoEOL = start + seq.subSequence(start, end).removeSuffix("\n").length();
            if (lastPos < end) {
                this.beforePre();
            }
            while (lastPos < endNoEOL) {
                int endPos;
                int pos = seq.indexOf(this.myEOL, lastPos, endNoEOL);
                int n = endPos = pos == -1 ? endNoEOL : pos + 1;
                if (lastPos < endPos) {
                    if (this.myPendingPreFormattedPrefix && !this.myPrefix.isEmpty()) {
                        this.myAppendable.append(this.myPrefix);
                    }
                    this.myPendingPreFormattedPrefix = false;
                    this.myAppendable.append(csq, lastPos, endPos);
                    lastPos = endPos;
                }
                if (pos == -1) break;
                this.updateLastEolOffset();
                ++this.myLineCount;
                this.myPendingPreFormattedPrefix = true;
                lastPos = endPos;
            }
            ++this.myModCount;
            if (lastPos == endNoEOL && endNoEOL != end) {
                this.myPendingEOL = 1;
                this.myPendingPreFormattedPrefix = true;
                this.mySpacesAfterEOL = 0;
            }
        } else {
            boolean firstAppend = true;
            while (lastPos < end) {
                int spanEnd;
                int pos = seq.indexOfAny(this.myWhitespaceEOL, lastPos, end);
                int n = spanEnd = pos == -1 ? end : pos;
                if (lastPos < spanEnd) {
                    this.beforeAppendText(true, true, true);
                    if (firstAppend) {
                        this.setOffsetBefore(this.myAppendable.getLength());
                        firstAppend = false;
                    }
                    this.myAppendable.append(csq, lastPos, spanEnd);
                    ++this.myModCount;
                }
                if (pos == -1) break;
                int span = seq.countChars(this.myWhitespaceEOL, pos, end);
                if (this.myPendingEOL == 0) {
                    int eolPos = seq.indexOf(this.myEOL, pos, pos + span);
                    if (eolPos != -1) {
                        if (eolPos > pos && !this.haveOptions(4)) {
                            this.addPendingSpaces(eolPos - pos);
                        }
                        this.setPendingEOL(1);
                    } else {
                        this.addPendingSpaces(span);
                    }
                } else if (this.isAllowLeadingWhitespace()) {
                    this.mySpacesAfterEOL += span;
                }
                lastPos = pos += span;
            }
        }
    }

    private int appendPretendColumn(CharSequence csq, int start, int end) {
        int column = this.column();
        boolean myPendingPreFormattedPrefix = this.myPendingPreFormattedPrefix;
        int myPendingSpaces = this.myPendingSpaces;
        int mySpacesAfterEOL = this.mySpacesAfterEOL;
        int prefixLength = this.myPrefix.length();
        if (this.myPassThrough) {
            if (this.myPendingEOL > 0) {
                column = 0;
                if (myPendingPreFormattedPrefix && !this.myPrefix.isEmpty()) {
                    column = prefixLength;
                }
                myPendingPreFormattedPrefix = false;
            }
            return column;
        }
        int lastPos = start;
        BasedSequence seq = BasedSequenceImpl.of(csq);
        if (this.myPreFormattedNesting > 0) {
            int endNoEOL = start + seq.subSequence(start, end).removeSuffix("\n").length();
            if (lastPos < end) {
                if (myPendingPreFormattedPrefix) {
                    column += prefixLength;
                }
                myPendingPreFormattedPrefix = false;
            }
            while (lastPos < endNoEOL) {
                int endPos;
                int pos = seq.indexOf(this.myEOL, lastPos, endNoEOL);
                int n = endPos = pos == -1 ? endNoEOL : pos + 1;
                if (lastPos < endPos) {
                    if (myPendingPreFormattedPrefix) {
                        column += prefixLength;
                    }
                    myPendingPreFormattedPrefix = false;
                    column += endPos - lastPos;
                    lastPos = endPos;
                }
                if (pos == -1) break;
                myPendingPreFormattedPrefix = true;
                lastPos = endPos;
            }
            if (lastPos == endNoEOL && endNoEOL != end) {
                myPendingPreFormattedPrefix = true;
            }
        } else {
            boolean firstAppend = true;
            while (lastPos < end) {
                int spanEnd;
                int pos = seq.indexOfAny(this.myWhitespaceEOL, lastPos, end);
                int n = spanEnd = pos == -1 ? end : pos;
                if (lastPos < spanEnd) {
                    boolean haveIndent;
                    int myIndentSize = this.myIndentPrefix.length() * (this.myIndent + this.myIndentOffset);
                    boolean bl = haveIndent = this.myIndent + this.myIndentOffset > 0 && !this.myIndentPrefix.isEmpty();
                    if (this.myPendingEOL > 0) {
                        column = 0;
                        if (!this.myPrefix.isEmpty()) {
                            column += prefixLength;
                        }
                        if (haveIndent) {
                            column += myIndentSize;
                        }
                    } else if (this.myModCountOfLastEOL == this.myModCount) {
                        if (!this.myPrefix.isEmpty()) {
                            column += prefixLength;
                        }
                        if (haveIndent) {
                            column += myIndentSize;
                        }
                    } else if (myPendingSpaces > 0) {
                        column += myPendingSpaces;
                    }
                    if (firstAppend) {
                        firstAppend = false;
                    }
                    column += spanEnd - lastPos;
                }
                if (pos == -1) break;
                int span = seq.countChars(this.myWhitespaceEOL, pos, end);
                if (this.myPendingEOL == 0) {
                    int count;
                    boolean handleSpaces;
                    int eolPos = seq.indexOf(this.myEOL, pos, pos + span);
                    boolean bl = handleSpaces = this.myPreFormattedNesting == 0 && this.myPendingEOL == 0 && this.myModCountOfLastEOL != this.myModCount;
                    if (eolPos != -1) {
                        if (eolPos > pos && !this.haveOptions(4) && (count = eolPos - pos) > 0 && handleSpaces) {
                            if (this.isCollapseWhitespace()) {
                                if (myPendingSpaces == 0) {
                                    myPendingSpaces = 1;
                                }
                            } else {
                                myPendingSpaces += count;
                            }
                        }
                    } else {
                        count = span;
                        if (count > 0 && handleSpaces) {
                            if (this.isCollapseWhitespace()) {
                                if (myPendingSpaces == 0) {
                                    myPendingSpaces = 1;
                                }
                            } else {
                                myPendingSpaces += count;
                            }
                        }
                    }
                } else if (this.isAllowLeadingWhitespace()) {
                    column += mySpacesAfterEOL;
                    mySpacesAfterEOL = 0;
                }
                lastPos = pos += span;
            }
        }
        return column;
    }

    @Override
    public IOException getIOException() {
        return this.myIOException;
    }

    private void setIOException(IOException e) {
        if (this.myIOException == null) {
            this.myIOException = e;
        }
    }

    @Override
    public FormattingAppendable append(CharSequence csq) {
        try {
            if (this.myIOException == null) {
                this.appendImpl(csq, 0, csq.length());
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public FormattingAppendable append(CharSequence csq, int start, int end) {
        try {
            if (this.myIOException == null) {
                this.appendImpl(csq, start, end);
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public FormattingAppendable append(char c) {
        try {
            if (this.myIOException == null) {
                this.appendImpl(c);
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public FormattingAppendable repeat(char c, int count) {
        int i = count;
        while (i-- > 0) {
            this.append(c);
        }
        return this;
    }

    @Override
    public FormattingAppendable repeat(CharSequence csq, int count) {
        int i = count;
        while (i-- > 0) {
            this.append(csq);
        }
        return this;
    }

    @Override
    public FormattingAppendable repeat(CharSequence csq, int start, int end, int count) {
        int i = count;
        while (i-- > 0) {
            this.append(csq, start, end);
        }
        return this;
    }

    @Override
    public Appendable getAppendable() {
        return this.myAppendable;
    }

    @Override
    public String getText() {
        Appendable appendable = this.flush().getAppendable();
        String result = appendable.toString();
        return result;
    }

    @Override
    public String getText(int maxBlankLines) {
        Appendable appendable = this.flush(maxBlankLines).getAppendable();
        String result = appendable.toString();
        return result;
    }

    @Override
    public FormattingAppendable flush() {
        return this.flush(0);
    }

    @Override
    public FormattingAppendable flushWhitespaces() {
        try {
            this.appendSpaces();
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public FormattingAppendable flush(int maxBlankLines) {
        int blankLines;
        assert (this.myConditionalFrames.size() == 0);
        assert (this.myPreFormattedNesting == 0);
        int n = blankLines = maxBlankLines >= -1 ? maxBlankLines : -1;
        if (this.myPendingEOL > blankLines + 1) {
            this.myPendingEOL = maxBlankLines + 1;
        }
        try {
            if (this.myIOException == null) {
                this.myOffsetBefore = this.myAppendable.getLength();
                this.appendEOL(false, false);
            }
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        return this;
    }

    @Override
    public CharSequence getIndentPrefix() {
        return this.myIndentPrefix;
    }

    @Override
    public FormattingAppendable setIndentPrefix(CharSequence prefix) {
        this.myIndentPrefix = CharSubSequence.of(prefix);
        return this;
    }

    @Override
    public BasedSequence getPrefix() {
        return this.myPrefix;
    }

    @Override
    public CharSequence getTotalIndentPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append(RepeatedCharSequence.of(this.myIndentPrefix, this.myIndent));
        return sb.toString();
    }

    @Override
    public FormattingAppendable setPrefix(CharSequence prefix) {
        final CharSubSequence fixedPrefix = CharSubSequence.of(prefix);
        if (this.myPendingEOL > 0 && this.isPrefixAfterPendingEol()) {
            this.addAfterEolRunnable(0, new Runnable(){

                @Override
                public void run() {
                    FormattingAppendableImpl.this.myPrefix = fixedPrefix;
                }
            });
        } else {
            this.myPrefix = fixedPrefix;
        }
        return this;
    }

    @Override
    public FormattingAppendable addPrefix(CharSequence prefix) {
        this.setPrefix(this.myPrefix.append(prefix));
        return this;
    }

    @Override
    public FormattingAppendable pushPrefix() {
        this.myPrefixStack.push(this.myPrefix);
        return this;
    }

    @Override
    public FormattingAppendable popPrefix() {
        if (this.myPrefixStack.isEmpty()) {
            throw new IllegalStateException("popPrefix with an empty stack");
        }
        BasedSequence prefix = this.myPrefixStack.pop();
        this.setPrefix(prefix);
        return this;
    }

    @Override
    public int getPushedPrefixCount() {
        return this.myPrefixStack.size();
    }

    @Override
    public FormattingAppendable line() {
        this.setPendingEOL(1);
        return this;
    }

    @Override
    public FormattingAppendable addLine() {
        this.setPendingEOL(this.myPendingEOL + 1);
        return this;
    }

    @Override
    public FormattingAppendable lineIf(boolean predicate) {
        if (predicate) {
            this.line();
        }
        return this;
    }

    @Override
    public FormattingAppendable line(Ref<Boolean> lineRef) {
        lineRef.value = true;
        if (this.myConditionalFrames.size() > 0) {
            ConditionalFrame frame = this.myConditionalFrames.peek();
            if (frame.myModCount == this.myModCount) {
                if (frame.myLineRef != null) {
                    frame.myLineRef.value = false;
                }
                frame.myLineRef = lineRef;
            }
        }
        this.setPendingEOL(1);
        return this;
    }

    @Override
    public FormattingAppendable lineIf(Ref<Boolean> lineRef) {
        if (((Boolean)lineRef.value).booleanValue()) {
            this.line();
        }
        return this;
    }

    @Override
    public FormattingAppendable blankLine() {
        this.setPendingEOL(2);
        return this;
    }

    @Override
    public FormattingAppendable blankLineIf(boolean predicate) {
        if (predicate) {
            this.blankLine();
        }
        return this;
    }

    @Override
    public FormattingAppendable blankLine(int count) {
        if (count > 0) {
            this.setPendingEOL(count + 1);
        }
        return this;
    }

    @Override
    public int getIndent() {
        return this.myIndent + this.myIndentOffset;
    }

    @Override
    public FormattingAppendable setIndentOffset(int indentOffset) {
        this.myIndentOffset = indentOffset;
        return this;
    }

    @Override
    public FormattingAppendable indent() {
        if (this.myPreFormattedNesting != 0) {
            throw new IllegalStateException("indent should not be called inside preFormatted");
        }
        if (!this.myPassThrough) {
            this.line();
            this.myIndentLineCounts.push(this.myLineCount);
        }
        this.myWillIndent = false;
        ++this.myIndent;
        return this;
    }

    @Override
    public FormattingAppendable willIndent() {
        this.myWillIndent = true;
        return this;
    }

    @Override
    public FormattingAppendable unIndent() {
        if (this.myIndent <= 0) {
            throw new IllegalStateException("unIndent called with nesting == 0");
        }
        if (!this.myPassThrough) {
            if (this.myPreFormattedNesting != 0) {
                throw new IllegalStateException("unIndent should not be called inside preFormatted");
            }
            int indentLineCount = this.myIndentLineCounts.pop();
            if (indentLineCount == this.myLineCount) {
                this.myPendingEOL = 0;
                this.runAllAfterEol();
            } else {
                this.line();
            }
        }
        --this.myIndent;
        return this;
    }

    @Override
    public int getModCount() {
        return this.myModCount;
    }

    @Override
    public int getLineCount() {
        return this.myLineCount;
    }

    @Override
    public FormattingAppendable lastOffset(Ref<Integer> refOffset) {
        this.myOffsetBeforeList.add(refOffset);
        return this;
    }

    @Override
    public int lastOffset() {
        return this.myOffsetBefore;
    }

    @Override
    public int offset() {
        return this.myAppendable.getLength();
    }

    @Override
    public int offsetWithPending() {
        return this.myAppendable.getLength() + (this.myModCountOfLastEOL == this.myModCount && this.haveOptions(4) ? 0 : this.myPendingSpaces) + this.myPendingEOL + (this.myPendingEOL > 0 ? this.myPrefix.length() : 0);
    }

    @Override
    public int column() {
        return this.myAppendable.getLength() - this.myLastEOLOffset;
    }

    @Override
    public int columnWith(CharSequence csq, int start, int end) {
        return this.appendPretendColumn(csq, start, end);
    }

    @Override
    public FormattingAppendable openPreFormatted(boolean keepIndent) {
        try {
            this.setOffsetBefore(this.myAppendable.getLength());
            if (!keepIndent) {
                this.myPendingPreFormattedPrefix = this.myPendingEOL > 0;
            }
            this.beforeAppendText(true, keepIndent, keepIndent);
        }
        catch (IOException e) {
            this.setIOException(e);
        }
        this.myPendingSpaces = 0;
        this.myPendingEOL = 0;
        this.runAllAfterEol();
        ++this.myPreFormattedNesting;
        return this;
    }

    @Override
    public FormattingAppendable closePreFormatted() {
        if (this.myPreFormattedNesting <= 0) {
            throw new IllegalStateException("closePreFormatted called with nesting == 0");
        }
        this.myPendingPreFormattedPrefix = false;
        --this.myPreFormattedNesting;
        return this;
    }

    @Override
    public boolean isPendingSpace() {
        return this.myPendingSpaces > 0;
    }

    @Override
    public boolean isPendingEOL() {
        return this.myPendingEOL > 0;
    }

    @Override
    public int getPendingEOL() {
        return this.myPendingEOL;
    }

    @Override
    public boolean isPreFormatted() {
        return this.myPreFormattedNesting > 0;
    }

    @Override
    public FormattingAppendable openConditional(ConditionalFormatter openFormatter) {
        ConditionalFrame frame = new ConditionalFrame(openFormatter, this.myModCount, this.myIndent, this.myLineCount);
        this.myConditionalFrames.push(frame);
        return this;
    }

    @Override
    public FormattingAppendable closeConditional(ConditionalFormatter closeFormatter) {
        if (this.myConditionalFrames.size() == 0) {
            throw new IllegalStateException("closeConditional called with no conditionals open");
        }
        ConditionalFrame frame = this.myConditionalFrames.pop();
        closeFormatter.apply(true, frame.myOnIndent, frame.myOnLine, frame.myModCount != this.myModCount);
        return this;
    }

    private static class ConditionalFrame {
        final ConditionalFormatter myOpenFormatter;
        final int myModCount;
        final int myIndent;
        final int myLineCount;
        Ref<Boolean> myLineRef;
        boolean myOnIndent;
        boolean myOnLine;
        boolean myInFormatter;

        ConditionalFrame(ConditionalFormatter openFormatter, int modCount, int indent, int lineCount) {
            this.myOpenFormatter = openFormatter;
            this.myModCount = modCount;
            this.myIndent = indent;
            this.myLineCount = lineCount;
            this.myLineRef = null;
            this.myOnIndent = false;
            this.myOnLine = false;
            this.myInFormatter = false;
        }
    }
}

