/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.remove;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.git.gitexe.command.status.GitStatusConsumer;
import org.apache.maven.scm.util.AbstractConsumer;

public class GitRemoveConsumer
extends AbstractConsumer {
    private static final Pattern REMOVED_PATTERN = Pattern.compile("^rm\\s'(.*)'");
    private final List<ScmFile> removedFiles = new ArrayList<ScmFile>();
    private final URI relativeRepositoryPath;

    public GitRemoveConsumer() {
        this(null);
    }

    public GitRemoveConsumer(URI relativeRepositoryPath) {
        this.relativeRepositoryPath = relativeRepositoryPath;
    }

    public void consumeLine(String line) {
        if (line.length() <= 2) {
            return;
        }
        Matcher matcher = REMOVED_PATTERN.matcher(line);
        if (!matcher.matches()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("could not parse line: " + line);
            }
            return;
        }
        String file = GitStatusConsumer.resolvePath(matcher.group(1), this.relativeRepositoryPath);
        this.removedFiles.add(new ScmFile(file, ScmFileStatus.DELETED));
    }

    public List<ScmFile> getRemovedFiles() {
        return this.removedFiles;
    }
}

