/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.Poly;

class PolyVecK {
    Poly[] vec;
    private MLDSAEngine engine;
    private int mode;
    private int polyVecBytes;
    private int dilithiumK;
    private int dilithiumL;

    public PolyVecK(MLDSAEngine mLDSAEngine) {
        this.engine = mLDSAEngine;
        this.mode = mLDSAEngine.getDilithiumMode();
        this.dilithiumK = mLDSAEngine.getDilithiumK();
        this.dilithiumL = mLDSAEngine.getDilithiumL();
        this.vec = new Poly[this.dilithiumK];
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.vec[j] = new Poly(mLDSAEngine);
        }
    }

    public PolyVecK() throws Exception {
        throw new Exception("Requires Parameter");
    }

    public Poly getVectorIndex(int n) {
        return this.vec[n];
    }

    public void setVectorIndex(int n, Poly poly) {
        this.vec[n] = poly;
    }

    public void uniformEta(byte[] byArray, short s) {
        short s2 = s;
        for (int j = 0; j < this.dilithiumK; ++j) {
            short s3 = s2;
            s2 = (short)(s2 + 1);
            this.getVectorIndex(j).uniformEta(byArray, s3);
        }
    }

    public void reduce() {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).reduce();
        }
    }

    public void invNttToMont() {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).invNttToMont();
        }
    }

    public void addPolyVecK(PolyVecK polyVecK) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).addPoly(polyVecK.getVectorIndex(j));
        }
    }

    public void conditionalAddQ() {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).conditionalAddQ();
        }
    }

    public void power2Round(PolyVecK polyVecK) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).power2Round(polyVecK.getVectorIndex(j));
        }
    }

    public void polyVecNtt() {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.vec[j].polyNtt();
        }
    }

    public void decompose(PolyVecK polyVecK) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).decompose(polyVecK.getVectorIndex(j));
        }
    }

    public byte[] packW1() {
        byte[] byArray = new byte[this.dilithiumK * this.engine.getDilithiumPolyW1PackedBytes()];
        for (int j = 0; j < this.dilithiumK; ++j) {
            System.arraycopy(this.getVectorIndex(j).w1Pack(), 0, byArray, j * this.engine.getDilithiumPolyW1PackedBytes(), this.engine.getDilithiumPolyW1PackedBytes());
        }
        return byArray;
    }

    public void pointwisePolyMontgomery(Poly poly, PolyVecK polyVecK) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).pointwiseMontgomery(poly, polyVecK.getVectorIndex(j));
        }
    }

    public void subtract(PolyVecK polyVecK) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).subtract(polyVecK.getVectorIndex(j));
        }
    }

    public boolean checkNorm(int n) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            if (!this.getVectorIndex(j).checkNorm(n)) continue;
            return true;
        }
        return false;
    }

    public int makeHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        int n = 0;
        for (int j = 0; j < this.dilithiumK; ++j) {
            n += this.getVectorIndex(j).polyMakeHint(polyVecK.getVectorIndex(j), polyVecK2.getVectorIndex(j));
        }
        return n;
    }

    public void useHint(PolyVecK polyVecK, PolyVecK polyVecK2) {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).polyUseHint(polyVecK.getVectorIndex(j), polyVecK2.getVectorIndex(j));
        }
    }

    public void shiftLeft() {
        for (int j = 0; j < this.dilithiumK; ++j) {
            this.getVectorIndex(j).shiftLeft();
        }
    }

    public String toString() {
        String string = "[";
        for (int j = 0; j < this.dilithiumK; ++j) {
            string = string + j + " " + this.getVectorIndex(j).toString();
            if (j == this.dilithiumK - 1) continue;
            string = string + ",\n";
        }
        string = string + "]";
        return string;
    }

    public String toString(String string) {
        return string + ": " + this.toString();
    }
}

