/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.AsymmetricAlgorithmSpec;
import net.messagevortex.asn1.MacAlgorithmSpec;
import net.messagevortex.asn1.SymmetricAlgorithmSpec;
import net.messagevortex.asn1.encryption.CipherUsage;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class CipherSpec
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000006L;
    private static final int SYMMETRIC = 16001;
    private static final int ASYMMETRIC = 16002;
    private static final int MAC = 16003;
    private static final int USAGE = 16004;
    private AsymmetricAlgorithmSpec asymmetricSpec = null;
    private SymmetricAlgorithmSpec symmetricSpec = null;
    private MacAlgorithmSpec macSpec = null;
    private CipherUsage cipherUsage = CipherUsage.ENCRYPT;

    public CipherSpec(ASN1Encodable to) throws IOException {
        this.parse(to);
    }

    public CipherSpec(CipherUsage cipherUsage) {
        this.cipherUsage = cipherUsage;
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1TaggedObject to1;
        ASN1Sequence s1 = ASN1Sequence.getInstance(to);
        int i2 = 0;
        if ((to1 = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++))).getTagNo() == 16002) {
            this.asymmetricSpec = new AsymmetricAlgorithmSpec(to1.getBaseObject());
            to1 = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        }
        if (to1.getTagNo() == 16001) {
            this.symmetricSpec = new SymmetricAlgorithmSpec(to1.getBaseObject());
            to1 = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        }
        if (to1.getTagNo() == 16003) {
            this.macSpec = new MacAlgorithmSpec(to1.getBaseObject());
            to1 = ASN1TaggedObject.getInstance(s1.getObjectAt(i2++));
        }
        if (to1.getTagNo() != 16004) {
            throw new IOException("expected USAGE (16004) but got " + to1.getTagNo() + " when parsing CipherSpec");
        }
        this.cipherUsage = CipherUsage.getById(ASN1Enumerated.getInstance(to1.getBaseObject()).getValue().intValue());
    }

    public AsymmetricAlgorithmSpec getAsymmetricSpec() {
        return this.asymmetricSpec;
    }

    public AsymmetricAlgorithmSpec setAsymmetricSpec(AsymmetricAlgorithmSpec spec) {
        AsymmetricAlgorithmSpec ret = this.asymmetricSpec;
        this.asymmetricSpec = spec;
        return ret;
    }

    public SymmetricAlgorithmSpec getSymmetricSpec() {
        return this.symmetricSpec;
    }

    public SymmetricAlgorithmSpec setSymmetricSpec(SymmetricAlgorithmSpec spec) {
        SymmetricAlgorithmSpec ret = this.symmetricSpec;
        this.symmetricSpec = spec;
        return ret;
    }

    public MacAlgorithmSpec getMacSpec() {
        return this.macSpec;
    }

    public MacAlgorithmSpec setMacSpec(MacAlgorithmSpec spec) {
        MacAlgorithmSpec ret = this.macSpec;
        this.macSpec = spec;
        return ret;
    }

    public CipherUsage getCipherUsage() {
        return this.cipherUsage;
    }

    public CipherUsage setCipherUsage(CipherUsage usage) {
        CipherUsage ret = this.cipherUsage;
        this.cipherUsage = usage;
        return ret;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\r\n");
        if (this.asymmetricSpec != null) {
            sb.append(prefix).append("  ").append("asymmetric ").append(this.asymmetricSpec.dumpValueNotation(prefix + "  ", dumpType)).append(',').append("\r\n");
        }
        if (this.symmetricSpec != null) {
            sb.append(prefix).append("  ").append("symmetric ").append(this.symmetricSpec.dumpValueNotation(prefix + "  ", dumpType)).append(',').append("\r\n");
        }
        if (this.macSpec != null) {
            sb.append(prefix).append("  ").append("mac ").append(this.macSpec.dumpValueNotation(prefix + "  ", dumpType)).append(',').append("\r\n");
        }
        sb.append(prefix).append("  ").append("cipherUsage ").append(this.cipherUsage.getUsageString()).append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) throws IOException {
        if (this.cipherUsage == null) {
            throw new IOException("CipherSpec is empty .. unable to create CipherSpec");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.asymmetricSpec != null) {
            v.add(new DERTaggedObject(16002, this.asymmetricSpec.toAsn1Object(dumpType)));
        }
        if (this.symmetricSpec != null) {
            v.add(new DERTaggedObject(16001, this.symmetricSpec.toAsn1Object(dumpType)));
        }
        if (this.macSpec != null) {
            v.add(new DERTaggedObject(16003, this.macSpec.toAsn1Object(dumpType)));
        }
        v.add(new DERTaggedObject(16004, new ASN1Enumerated(this.cipherUsage.getId())));
        return new DERSequence(v);
    }

    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t.getClass() != this.getClass()) {
            return false;
        }
        CipherSpec o = (CipherSpec)t;
        try {
            return this.dumpValueNotation("", DumpType.ALL).equals(o.dumpValueNotation("", DumpType.ALL));
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.dumpValueNotation("", DumpType.ALL).hashCode();
        }
        catch (IOException ioe) {
            return "FAILED".hashCode();
        }
    }
}

