/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public class MapFetchEntriesOperation
extends MapOperation
implements ReadonlyOperation {
    private int fetchSize;
    private IterationPointer[] pointers;
    private transient MapEntriesWithCursor response;

    public MapFetchEntriesOperation() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="This is an internal class")
    public MapFetchEntriesOperation(String name, IterationPointer[] pointers, int fetchSize) {
        super(name);
        this.pointers = pointers;
        this.fetchSize = fetchSize;
    }

    @Override
    protected void runInternal() {
        this.response = this.recordStore.fetchEntries(this.pointers, this.fetchSize);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.fetchSize = in.readInt();
        int pointersCount = in.readInt();
        this.pointers = new IterationPointer[pointersCount];
        for (int i2 = 0; i2 < pointersCount; ++i2) {
            this.pointers[i2] = new IterationPointer(in.readInt(), in.readInt());
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.fetchSize);
        out.writeInt(this.pointers.length);
        for (IterationPointer pointer : this.pointers) {
            out.writeInt(pointer.getIndex());
            out.writeInt(pointer.getSize());
        }
    }

    @Override
    public int getClassId() {
        return 45;
    }
}

