/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.retry.impl;

import com.hazelcast.jet.retry.RetryStrategy;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;

public class RetryTracker {
    private final RetryStrategy strategy;
    private final LongSupplier currentTime;
    private int attempt;
    private long nextTryNanoTime;

    public RetryTracker(RetryStrategy strategy) {
        this(strategy, System::nanoTime);
    }

    RetryTracker(RetryStrategy strategy, LongSupplier currentTime) {
        this.strategy = strategy;
        this.currentTime = currentTime;
    }

    public void reset() {
        this.attempt = 0;
        this.nextTryNanoTime = this.currentTime.getAsLong();
    }

    public boolean needsToWait() {
        return this.attempt > 0 && this.currentTime.getAsLong() < this.nextTryNanoTime;
    }

    public boolean shouldTryAgain() {
        int maxAttempts = this.strategy.getMaxAttempts();
        return maxAttempts < 0 || maxAttempts > 0 && this.attempt <= maxAttempts;
    }

    public void attemptFailed() {
        ++this.attempt;
        long waitTimeMs = this.getNextWaitTimeMs();
        this.nextTryNanoTime = this.currentTime.getAsLong() + TimeUnit.MILLISECONDS.toNanos(waitTimeMs);
    }

    public long getNextWaitTimeMs() {
        return this.strategy.getIntervalFunction().waitAfterAttempt(this.attempt);
    }
}

