/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.jet.impl.connector.AbstractUpdateMapP;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.QueryableEntry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import javax.annotation.Nonnull;

public final class UpdateMapP<T, K, V>
extends AbstractUpdateMapP<T, K, V> {
    private final BiFunctionEx<? super V, ? super T, ? extends V> updateFn;
    private final BinaryOperator<Object> remappingFunction = (o, n) -> ApplyFnEntryProcessor.append(o, (Data)n);

    public UpdateMapP(HazelcastInstance instance, String mapName, @Nonnull FunctionEx<? super T, ? extends K> keyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        this(instance, 1000, mapName, keyFn, updateFn);
    }

    UpdateMapP(HazelcastInstance instance, int maxParallelAsyncOps, String mapName, @Nonnull FunctionEx<? super T, ? extends K> keyFn, @Nonnull BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
        super(instance, maxParallelAsyncOps, mapName, keyFn);
        this.updateFn = updateFn;
    }

    @Override
    protected EntryProcessor<K, V, Void> entryProcessor(Map<Data, Object> buffer) {
        return new ApplyFnEntryProcessor(buffer, this.updateFn);
    }

    @Override
    protected void addToBuffer(T item) {
        Object key = this.keyFn.apply(item);
        Data keyData = this.serializationContext.toKeyData(key);
        int partitionId = this.serializationContext.partitionId(keyData);
        Data itemData = this.serializationContext.toData(item);
        this.partitionBuffers[partitionId].merge(keyData, itemData, this.remappingFunction);
        int n = partitionId;
        this.pendingInPartition[n] = this.pendingInPartition[n] + 1;
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    public static class ApplyFnEntryProcessor<K, V, T>
    implements EntryProcessor<K, V, Void>,
    IdentifiedDataSerializable,
    SerializationServiceAware {
        private Map<Data, Object> keysToUpdate;
        private BiFunctionEx<? super V, ? super T, ? extends V> updateFn;
        private SerializationService serializationService;

        public ApplyFnEntryProcessor() {
        }

        ApplyFnEntryProcessor(Map<Data, Object> keysToUpdate, BiFunctionEx<? super V, ? super T, ? extends V> updateFn) {
            this.keysToUpdate = keysToUpdate;
            this.updateFn = updateFn;
        }

        @Override
        public Void process(Map.Entry<K, V> entry) {
            Data keyData = ((QueryableEntry)entry).getKeyData();
            Object item = this.keysToUpdate.get(keyData);
            if (item == null && !this.keysToUpdate.containsKey(keyData)) {
                throw new JetException("A key not found in the map - is equals/hashCode correctly implemented for the key? Key type: " + entry.getKey().getClass().getName());
            }
            if (item instanceof List) {
                List castList = (List)item;
                for (Data o : castList) {
                    this.handle(entry, o);
                }
            } else {
                this.handle(entry, (Data)item);
            }
            return null;
        }

        private void handle(Map.Entry<K, V> entry, Data itemData) {
            Object item = this.serializationService.toObject(itemData);
            V oldValue = entry.getValue();
            V newValue = this.updateFn.apply(oldValue, item);
            entry.setValue(newValue);
        }

        @Override
        public void setSerializationService(SerializationService serializationService) {
            this.serializationService = serializationService;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.keysToUpdate.size());
            for (Map.Entry<Data, Object> en : this.keysToUpdate.entrySet()) {
                IOUtil.writeData(out, en.getKey());
                Object value = en.getValue();
                if (value instanceof Data) {
                    Data data = (Data)value;
                    out.writeInt(1);
                    IOUtil.writeData(out, data);
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    out.writeInt(list.size());
                    for (Data data : list) {
                        IOUtil.writeData(out, data);
                    }
                    continue;
                }
                assert (false) : "Unknown value type: " + value.getClass();
            }
            out.writeObject(this.updateFn);
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int keysToUpdateSize = in.readInt();
            this.keysToUpdate = MapUtil.createHashMap(keysToUpdateSize);
            for (int i = 0; i < keysToUpdateSize; ++i) {
                Object value;
                Data key = IOUtil.readData(in);
                int size = in.readInt();
                if (size == 1) {
                    value = IOUtil.readData(in);
                } else {
                    ArrayList<Data> list = new ArrayList<Data>(size);
                    for (int j = 0; j < size; ++j) {
                        list.add(IOUtil.readData(in));
                    }
                    value = list;
                }
                this.keysToUpdate.put(key, value);
            }
            this.updateFn = (BiFunctionEx)in.readObject();
        }

        @Override
        public int getFactoryId() {
            return JetDataSerializerHook.FACTORY_ID;
        }

        @Override
        public int getClassId() {
            return 3;
        }

        static Object append(Object value, Data item) {
            ArrayList<Data> list;
            if (value instanceof List) {
                list = (ArrayList<Data>)value;
            } else {
                list = new ArrayList<Data>();
                list.add((Data)value);
            }
            list.add(item);
            return list;
        }
    }
}

