/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.yaml;

import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNameNodePair;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.internal.yaml.YamlScalar;
import com.hazelcast.internal.yaml.YamlSequence;
import com.hazelcast.shaded.org.json.JSONArray;
import com.hazelcast.shaded.org.json.JSONObject;

public final class YamlToJsonConverter {
    private YamlToJsonConverter() {
    }

    public static Object convert(YamlNode yamlNode) {
        if (yamlNode == null) {
            return JSONObject.NULL;
        }
        if (yamlNode instanceof YamlMapping) {
            YamlMapping yamlMapping = (YamlMapping)yamlNode;
            JSONObject resultObject = new JSONObject();
            for (YamlNameNodePair pair : yamlMapping.childrenPairs()) {
                resultObject.put(pair.nodeName(), YamlToJsonConverter.convert(pair.childNode()));
            }
            return resultObject;
        }
        if (yamlNode instanceof YamlSequence) {
            YamlSequence yamlSequence = (YamlSequence)yamlNode;
            JSONArray resultArray = new JSONArray();
            for (YamlNode child : yamlSequence.children()) {
                resultArray.put(YamlToJsonConverter.convert(child));
            }
            return resultArray;
        }
        if (yamlNode instanceof YamlScalar) {
            YamlScalar scalar = (YamlScalar)yamlNode;
            return scalar.nodeValue();
        }
        throw new IllegalArgumentException("Unknown type " + yamlNode.getClass().getName());
    }
}

