/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.RestEndpointGroup;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Deprecated(since="5.5", forRemoval=true)
public class RestApiConfig {
    private boolean enabled;
    private final Set<Integer> enabledGroupCodes = Collections.synchronizedSet(new HashSet());

    public RestApiConfig() {
        for (RestEndpointGroup eg : RestEndpointGroup.getAllEndpointGroups()) {
            if (!eg.isEnabledByDefault()) continue;
            this.enabledGroupCodes.add(eg.getCode());
        }
    }

    public RestApiConfig enableAllGroups() {
        return this.enableGroups(RestEndpointGroup.getAllEndpointGroups().toArray(new RestEndpointGroup[0]));
    }

    public RestApiConfig enableGroups(RestEndpointGroup ... endpointGroups) {
        if (endpointGroups != null) {
            this.enabledGroupCodes.addAll(Arrays.stream(endpointGroups).map(RestEndpointGroup::getCode).collect(Collectors.toSet()));
        }
        return this;
    }

    public RestApiConfig disableAllGroups() {
        this.enabledGroupCodes.clear();
        return this;
    }

    public RestApiConfig disableGroups(RestEndpointGroup ... endpointGroups) {
        if (endpointGroups != null) {
            Arrays.stream(endpointGroups).map(RestEndpointGroup::getCode).forEach(this.enabledGroupCodes::remove);
        }
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledAndNotEmpty() {
        return this.enabled && !this.enabledGroupCodes.isEmpty();
    }

    public RestApiConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Set<RestEndpointGroup> getEnabledGroups() {
        return this.enabledGroupCodes.stream().map(RestEndpointGroup::getRestEndpointGroup).collect(Collectors.toSet());
    }

    public boolean isGroupEnabled(RestEndpointGroup group) {
        return this.enabledGroupCodes.contains(group.getCode());
    }

    public RestApiConfig setEnabledGroups(Collection<RestEndpointGroup> groups) {
        this.enabledGroupCodes.clear();
        if (groups != null) {
            this.enabledGroupCodes.addAll(groups.stream().map(RestEndpointGroup::getCode).collect(Collectors.toSet()));
        }
        return this;
    }

    public String toString() {
        return "RestApiConfig{enabled=" + this.enabled + ", enabledGroups=" + this.getEnabledGroups() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestApiConfig that = (RestApiConfig)o;
        return this.enabled == that.enabled && Objects.equals(this.enabledGroupCodes, that.enabledGroupCodes);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.enabledGroupCodes);
    }
}

