/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.transaction;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.XATransactionClearRemoteCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.operations.ClearRemoteTransactionOperation;
import java.security.Permission;

public class XAClearRemoteTransactionMessageTask
extends AbstractCallableMessageTask<SerializableXID> {
    private static final int TRY_COUNT = 100;

    public XAClearRemoteTransactionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected SerializableXID decodeClientMessage(ClientMessage clientMessage) {
        return XATransactionClearRemoteCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return XATransactionClearRemoteCodec.encodeResponse();
    }

    @Override
    protected Object call() throws Exception {
        OperationService operationService = this.nodeEngine.getOperationService();
        IPartitionService partitionService = this.nodeEngine.getPartitionService();
        Object xidData = this.serializationService.toData(this.parameters);
        ClearRemoteTransactionOperation op = new ClearRemoteTransactionOperation((Data)xidData);
        op.setCallerUuid(this.endpoint.getUuid());
        int partitionId = partitionService.getPartitionId((Data)xidData);
        InvocationBuilder builder = operationService.createInvocationBuilder(this.getServiceName(), (Operation)op, partitionId);
        builder.setTryCount(100).setResultDeserialized(false);
        builder.invoke();
        return XATransactionClearRemoteCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "clearRemoteTransaction";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.parameters};
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

