/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport.dummy;

import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.AbstractDaemon;
import net.messagevortex.Config;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.MessageVortexRepository;
import net.messagevortex.blender.Blender;
import net.messagevortex.transport.ByteArrayBuilder;
import net.messagevortex.transport.RandomString;
import net.messagevortex.transport.Transport;
import net.messagevortex.transport.TransportReceiver;

public class DummyTransportTrx
extends AbstractDaemon
implements Transport {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private static String defHostname;
    private static Map<String, String> idReservation;
    private static final Object mon;
    private static boolean localMode;
    static final Map<String, TransportReceiver> endpoints;
    private static String name;
    private String registeredEndpoint = null;

    public DummyTransportTrx(String section) throws IOException {
        this.initCluster();
        LOGGER.log(Level.INFO, "setup of dummy endpoint for section \"" + section + "\"");
        String id = Config.getDefault().getStringValue(section, "transport_id");
        LOGGER.log(Level.INFO, "  id is \"" + id + "\"");
        String blenderName = Config.getDefault().getStringValue(section, "blender");
        LOGGER.log(Level.INFO, "  blender is \"" + blenderName + "\"");
        Blender blender = MessageVortexRepository.getBlender("", blenderName);
        LOGGER.log(Level.INFO, "  blender " + (blender != null ? "found" : "not found"));
        LOGGER.log(Level.INFO, "  initializing transport");
        this.init(id, blender);
        LOGGER.log(Level.INFO, "setup of dummy endpoint for section \"" + section + "\" done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setClusterName(String newName) throws IOException {
        Object object = mon;
        synchronized (object) {
            if (idReservation != null) {
                throw new IOException("Cluster is already initialized");
            }
            name = newName;
        }
    }

    public DummyTransportTrx(String id, TransportReceiver blender) throws IOException {
        this.init(id, blender);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DummyTransportTrx(TransportReceiver blender) throws IOException {
        this.initCluster();
        Map<String, TransportReceiver> map = endpoints;
        synchronized (map) {
            String id = null;
            while (id == null || idReservation.containsKey(id)) {
                id = RandomString.nextString(5, "0123456789abcdef@example.com");
            }
            this.init(id, blender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCluster() throws IOException {
        Object object = mon;
        synchronized (object) {
            if (idReservation == null) {
                if (name == null || "".equals(name)) {
                    name = InetAddress.getLocalHost().getHostName() + "-" + RandomString.nextString(5);
                    LOGGER.log(Level.INFO, "  Got hazelcast instance name  " + name + " from node");
                }
                HazelcastInstance hz = Hazelcast.getOrCreateHazelcastInstance((com.hazelcast.config.Config)new com.hazelcast.config.Config(name));
                idReservation = localMode ? new HashMap<String, String>() : hz.getMap("dummyTransportTrxEndpoints");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setLocalMode(boolean lm) throws IOException {
        boolean old = localMode;
        Object object = mon;
        synchronized (object) {
            if (idReservation != null) {
                throw new IOException("Cluster is already initialized");
            }
            localMode = lm;
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void init(String id, TransportReceiver blender) throws IOException {
        defHostname = InetAddress.getLocalHost().getHostName();
        this.initCluster();
        Map<String, TransportReceiver> map = endpoints;
        synchronized (map) {
            if (idReservation.containsKey(id)) {
                throw new IOException("Duplicate transport endpoint identifier (id:" + id + ")");
            }
            LOGGER.log(Level.INFO, "Registering " + id + " to node " + defHostname);
            idReservation.put(id, defHostname);
            this.registeredEndpoint = id;
            endpoints.put(id, blender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownDaemon() {
        Vector<String> l = new Vector<String>();
        Map<String, String> map = idReservation;
        synchronized (map) {
            for (Map.Entry<String, String> e : idReservation.entrySet()) {
                if (!e.getValue().equals(defHostname)) continue;
                l.add(e.getKey());
            }
            for (String key : l.toArray(new String[0])) {
                String hostname = idReservation.remove(key);
                if (hostname != null && hostname.equals(defHostname)) {
                    LOGGER.log(Level.FINE, "successfully de-registered id " + this.registeredEndpoint + " from dummy transport");
                    continue;
                }
                LOGGER.log(Level.SEVERE, "OUCH... for some reasons this endpoint was registered to a different host (" + hostname + "). It is unclear if your system is still working properly.");
            }
        }
        super.shutdownDaemon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(String address, InputStream is) throws IOException {
        int n;
        final TransportReceiver ep = endpoints.get(address);
        if (address == null || ep == null) {
            throw new IOException("recipient address is unknown");
        }
        ByteArrayBuilder bab = new ByteArrayBuilder();
        byte[] buffer = new byte[1024];
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            bab.append(buffer, n);
        }
        is.close();
        byte[] arr = bab.toBytes();
        LOGGER.log(Level.INFO, "Dummy transport received " + arr.length + " sized message");
        final ByteArrayInputStream iso = new ByteArrayInputStream(arr);
        Map<String, TransportReceiver> map = endpoints;
        synchronized (map) {
            new Thread(){

                @Override
                public void run() {
                    ep.gotMessage(iso);
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDummyEndpoints() {
        Map<String, TransportReceiver> map = endpoints;
        synchronized (map) {
            endpoints.clear();
            if (!localMode && idReservation != null) {
                ((MapProxyImpl)idReservation).destroy();
            }
            idReservation = null;
            name = null;
        }
    }

    static {
        idReservation = null;
        mon = new Object();
        localMode = false;
        endpoints = new HashMap<String, TransportReceiver>();
        name = null;
    }
}

