/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.util.LineLoggingBuffer;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LoggingOutputStream
extends FilterOutputStream {
    protected final LineLoggingBuffer loggingBuffer;

    public LoggingOutputStream(OutputStream out, String prefix) {
        super(out);
        this.loggingBuffer = new LineLoggingBuffer(prefix);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.loggingBuffer.append(b);
        super.write(b);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.loggingBuffer.logLine();
        super.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.loggingBuffer.logLine();
        super.close();
    }
}

